/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.image;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.fest.swing.image.ImageException;
import org.fest.util.Files;
import org.fest.util.Strings;

public final class ScreenshotTaker {
    public static final String PNG_EXTENSION = "png";
    private final Robot robot;

    public ScreenshotTaker() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            throw new ImageException("Unable to create AWT Robot", e);
        }
    }

    public void saveDesktopAsPng(String imageFilePath) {
        this.saveImage(this.takeDesktopScreenshot(), imageFilePath);
    }

    public BufferedImage takeDesktopScreenshot() {
        Rectangle screen = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return this.robot.createScreenCapture(screen);
    }

    public void saveComponentAsPng(Component c, String imageFilePath) {
        this.saveImage(this.takeScreenshotOf(c), imageFilePath);
    }

    public BufferedImage takeScreenshotOf(Component c) {
        Point locationOnScreen = c.getLocationOnScreen();
        Dimension size = c.getSize();
        Rectangle r = new Rectangle(locationOnScreen.x, locationOnScreen.y, size.width, size.height);
        return this.robot.createScreenCapture(r);
    }

    public void saveImage(BufferedImage image, String filePath) {
        this.validate(filePath);
        try {
            ImageIO.write((RenderedImage)image, PNG_EXTENSION, Files.newFile((String)filePath));
        }
        catch (IOException e) {
            throw new ImageException(Strings.concat((Object[])new Object[]{"Unable to save image as ", Strings.quote((String)filePath)}), e);
        }
    }

    private void validate(String imageFilePath) {
        if (Strings.isEmpty((String)imageFilePath)) {
            throw new ImageException("The image path cannot be empty");
        }
        if (!imageFilePath.endsWith(PNG_EXTENSION)) {
            throw new ImageException(Strings.concat((Object[])new Object[]{"The image file should be a ", PNG_EXTENSION.toUpperCase(Locale.getDefault())}));
        }
    }
}

