/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.WindowLikeContainerDriver;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public class WindowDriver
extends WindowLikeContainerDriver {
    public WindowDriver(Robot robot) {
        super(robot);
    }

    public void resizeWidthTo(Window w, int width) {
        this.resizeTo(w, new Dimension(width, w.getSize().height));
    }

    public void resizeHeightTo(Window w, int height) {
        this.resizeTo(w, new Dimension(w.getSize().width, height));
    }

    public void resizeTo(Window w, Dimension size) {
        if (!this.isUserResizable(w)) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"The window ", Formatting.format(w), " is not resizable by the user"}));
        }
        this.resize(w, size.width, size.height);
    }

    public void moveTo(Window w, Point where) {
        if (!this.isUserMovable(w)) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"The window ", Formatting.format(w), " is not movable by the user"}));
        }
        this.move(w, where.x, where.y);
    }

    public void close(Window w) {
        this.robot.close(w);
    }

    public void show(Window w) {
        this.robot.showWindow(w);
        this.requireVisible(w);
    }

    public void show(Window w, Dimension size) {
        this.robot.showWindow(w, size);
        this.requireVisible(w);
    }
}

