/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import org.fest.swing.core.Condition;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public class WaitForComponentToShowCondition
extends Condition {
    private final Component c;

    public static WaitForComponentToShowCondition untilShowing(Component c) {
        return new WaitForComponentToShowCondition(c);
    }

    public WaitForComponentToShowCondition(Component c) {
        super(Strings.concat((Object[])new Object[]{"Component ", Formatting.format(c), " to show on the screen"}));
        if (c == null) {
            throw new NullPointerException("The component to verify should not be null");
        }
        this.c = c;
    }

    public boolean test() {
        return this.c.isShowing();
    }
}

