/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public final class JTreeLocation {
    public Point pointAt(JTree tree, int row) {
        return this.pointAt(tree, this.pathFor(tree, row));
    }

    public Point pointAt(JTree tree, TreePath path) {
        Rectangle pathBounds = tree.getPathBounds(path);
        if (pathBounds != null) {
            return new Point(pathBounds.x + pathBounds.width / 2, pathBounds.y + pathBounds.height / 2);
        }
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"The tree path ", Arrays.format((Object)path.getPath()), " is not visible"}));
    }

    public TreePath pathFor(JTree tree, int row) {
        TreePath path = tree.getPathForRow(this.validated(tree, row));
        if (path != null) {
            return path;
        }
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find tree path for row [", String.valueOf(row), "]"}));
    }

    private int validated(JTree tree, int row) {
        int rowCount = tree.getRowCount();
        if (row >= 0 && row < rowCount) {
            return row;
        }
        throw new IndexOutOfBoundsException(Strings.concat((Object[])new Object[]{"The given row (", String.valueOf(row), ") should be greater than or equal to 0 and less than ", String.valueOf(rowCount)}));
    }
}

