/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.fest.reflect.core.Reflection;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JToolBarLocation;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public class JToolBarDriver
extends JComponentDriver {
    private final JToolBarLocation location = new JToolBarLocation();

    public JToolBarDriver(Robot robot) {
        super(robot);
    }

    public boolean isFloating(JToolBar toolBar) {
        ToolBarUI ui = toolBar.getUI();
        if (ui instanceof BasicToolBarUI) {
            return ((BasicToolBarUI)ui).isFloating();
        }
        Window w = SwingUtilities.getWindowAncestor(toolBar);
        return !(w instanceof Frame) && toolBar.getParent().getComponentCount() == 1;
    }

    public void makeFloat(JToolBar toolBar) {
        Window w = SwingUtilities.getWindowAncestor(toolBar);
        Point where = w.getLocation();
        this.floatTo(toolBar, where.x, where.y);
    }

    public void floatTo(JToolBar toolBar, int x, int y) {
        if (!toolBar.isFloatable()) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"JToolbar <", Formatting.format(toolBar), "> is not floatable"}));
        }
        Window w = SwingUtilities.getWindowAncestor(toolBar);
        this.drag(toolBar, this.location.pointToGrab(toolBar));
        this.drop(w, new Point(x - w.getX(), y - w.getY()));
        if (!this.isFloating(toolBar)) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to float JToolbar <", Formatting.format(toolBar), ">"}));
        }
    }

    public void unfloat(JToolBar toolBar, String constraint) {
        Container dock = this.dockFor(toolBar);
        this.drag(toolBar, this.location.pointToGrab(toolBar));
        this.drop(dock, this.location.dockLocation(toolBar, dock, constraint));
        if (this.isFloating(toolBar)) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Failed to dock <", Formatting.format(toolBar), "> using constraint ", Strings.quote((String)constraint)}));
        }
    }

    private Container dockFor(JToolBar toolBar) {
        Container dock = null;
        try {
            dock = (Container)Reflection.field((String)"dockingSource").ofType(Container.class).in((Object)toolBar.getUI()).get();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (dock != null) {
            return dock;
        }
        throw ActionFailedException.actionFailure("Unabled to determine dock for JToolBar");
    }

    public void unfloat(JToolBar toolBar) {
        Window w = SwingUtilities.getWindowAncestor(toolBar);
        this.robot.close(w);
        this.robot.waitForIdle();
    }
}

