/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.fest.swing.core.Pause;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractJTableCellWriter;
import org.fest.swing.driver.CancelTableCellEditingTask;
import org.fest.swing.driver.JComboBoxDriver;
import org.fest.swing.driver.WaitForComponentToShowCondition;

public class JTableComboBoxEditorCellWriter
extends AbstractJTableCellWriter {
    private final JComboBoxDriver driver;

    public JTableComboBoxEditorCellWriter(Robot robot) {
        super(robot);
        this.driver = new JComboBoxDriver(robot);
    }

    public void enterValue(JTable table, int row, int column, String value) {
        JComboBox editor = this.editor(table, row, column);
        this.startCellEditing(table, row, column);
        this.driver.selectItem(editor, value);
    }

    public void startCellEditing(JTable table, int row, int column) {
        JComboBox editor = this.editor(table, row, column);
        this.clickCell(table, row, column);
        Pause.pause(new WaitForComponentToShowCondition(editor));
    }

    public void stopCellEditing(JTable table, int row, int column) {
        this.editor(table, row, column);
    }

    public void cancelCellEditing(JTable table, int row, int column) {
        this.editor(table, row, column);
        this.robot.invokeAndWait(new CancelTableCellEditingTask(table, row, column));
    }

    private JComboBox editor(JTable table, int row, int column) {
        Component editor = this.editorForCell(table, row, column);
        if (editor instanceof JComboBox) {
            return (JComboBox)editor;
        }
        throw this.cannotHandleEditor(editor);
    }
}

