/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.Strings;

public class JTabbedPaneLocation {
    public int indexOf(JTabbedPane tabbedPane, String title) {
        for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
            if (!Strings.match(title, tabbedPane.getTitleAt(i))) continue;
            return i;
        }
        throw new LocationUnavailableException(org.fest.util.Strings.concat((Object[])new Object[]{"Unable to find a tab with title ", org.fest.util.Strings.quote((String)title)}));
    }

    public Point pointAt(JTabbedPane tabbedPane, int index) {
        this.validateIndex(tabbedPane, index);
        Rectangle rect = tabbedPane.getUI().getTabBounds(tabbedPane, index);
        if (rect == null || rect.x < 0) {
            throw new LocationUnavailableException(org.fest.util.Strings.concat((Object[])new Object[]{"The tab '", String.valueOf(index), "' is not visible"}));
        }
        return new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
    }

    void validateIndex(JTabbedPane tabbedPane, int index) {
        int max = tabbedPane.getTabCount() - 1;
        if (index >= 0 && index <= max) {
            return;
        }
        throw ActionFailedException.actionFailure(org.fest.util.Strings.concat((Object[])new Object[]{"Index <", String.valueOf(index), "> is not within the JTabbedPane bounds of <0> and <", String.valueOf(max), "> (inclusive)"}));
    }
}

