/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JSlider;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JSliderLocation;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Strings;

public class JSliderDriver
extends JComponentDriver {
    private final JSliderLocation location = new JSliderLocation();

    public JSliderDriver(Robot robot) {
        super(robot);
    }

    public void slideToMaximum(JSlider slider) {
        this.slide(slider, slider.getMaximum());
    }

    public void slideToMinimum(JSlider slider) {
        this.slide(slider, slider.getMinimum());
    }

    public void slide(JSlider slider, int value) {
        this.validateValue(slider, value);
        if (!slider.isEnabled()) {
            return;
        }
        this.drag(slider, this.location.pointAt(slider, slider.getValue()));
        this.drop(slider, this.location.pointAt(slider, value));
        this.robot.invokeAndWait(new SetValueTask(slider, value));
    }

    private void validateValue(JSlider slider, int value) {
        int min = slider.getMinimum();
        int max = slider.getMaximum();
        if (value >= min && value <= max) {
            return;
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Value <", String.valueOf(value), "> is not within the JSlider bounds of <", String.valueOf(min), "> and <", String.valueOf(max), ">"}));
    }

    private static class SetValueTask
    implements Runnable {
        private final JSlider target;
        private final int value;

        SetValueTask(JSlider target, int value) {
            this.target = target;
            this.value = value;
        }

        public void run() {
            this.target.setValue(this.value);
        }
    }
}

