/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import org.fest.swing.core.ComponentMatcher;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeMatcher
implements ComponentMatcher {
    private final Class<? extends Component> type;
    private final boolean requireShowing;

    public TypeMatcher(Class<? extends Component> type) {
        this(type, false);
    }

    public TypeMatcher(Class<? extends Component> type, boolean requireShowing) {
        if (type == null) {
            throw new NullPointerException("The type of component to find should not be null");
        }
        this.type = type;
        this.requireShowing = requireShowing;
    }

    @Override
    public boolean matches(Component c) {
        return this.type.isAssignableFrom(c.getClass()) && (!this.requireShowing || c.isShowing());
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "type=", this.type.getName(), ", ", "requireShowing=", String.valueOf(this.requireShowing), "]"});
    }
}

