/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import org.fest.swing.util.Arrays;

public final class KeyPressInfo {
    private final int keyCode;
    private int[] modifiers;

    public static KeyPressInfo keyCode(int keyCode) {
        return new KeyPressInfo(keyCode, new int[0]);
    }

    private KeyPressInfo(int keyCode, int[] modifiers) {
        this.keyCode = keyCode;
        this.modifiers = modifiers;
    }

    public int keyCode() {
        return this.keyCode;
    }

    public int[] modifiers() {
        if (this.modifiers == null) {
            return new int[0];
        }
        return Arrays.copyOf(this.modifiers);
    }

    public KeyPressInfo modifiers(int ... newModifiers) {
        if (newModifiers == null) {
            throw new NullPointerException("The array of modifiers should not be null");
        }
        this.modifiers = Arrays.copyOf(newModifiers);
        return this;
    }
}

