/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.util.Collections;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectArrayAssert
extends ArrayAssert<Object[]> {
    ObjectArrayAssert(Object ... actual) {
        super(actual);
    }

    public ObjectArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public ObjectArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public ObjectArrayAssert hasAllElementsOfType(Class<?> type) {
        this.isNotNull();
        for (Object o : (Object[])this.actual) {
            if (type.isInstance(o)) continue;
            this.fail(Strings.concat((Object[])new Object[]{"not all elements in array:", this.actualInBrackets(), " belong to the type:", Formatting.inBrackets(type)}));
        }
        return this;
    }

    public ObjectArrayAssert hasAtLeastOneElementOfType(Class<?> type) {
        this.isNotNull();
        boolean found = false;
        for (Object o : (Object[])this.actual) {
            if (!type.isInstance(o)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.fail(Strings.concat((Object[])new Object[]{"array:", this.actualInBrackets(), " does not have any elements of type:", Formatting.inBrackets(type)}));
        }
        return this;
    }

    public ObjectArrayAssert contains(Object ... objects) {
        this.isNotNull();
        this.assertContains(Collections.list((Object[])objects));
        return this;
    }

    public ObjectArrayAssert containsOnly(Object ... objects) {
        this.isNotNull();
        this.assertContainsOnly(Collections.list((Object[])objects));
        return this;
    }

    public ObjectArrayAssert excludes(Object ... objects) {
        this.isNotNull();
        this.assertExcludes(Collections.list((Object[])objects));
        return this;
    }

    @Override
    List<Object> copyActual() {
        return Collections.list((Object[])((Object[])this.actual));
    }

    public ObjectArrayAssert satisfies(Condition<Object[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ObjectArrayAssert doesNotSatisfy(Condition<Object[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ObjectArrayAssert isNotNull() {
        this.assertArrayNotNull();
        return this;
    }

    public ObjectArrayAssert isNotEmpty() {
        this.assertNotEmpty();
        return this;
    }

    public ObjectArrayAssert isEqualTo(Object[] expected) {
        if (!Arrays.equals((Object[])this.actual, expected)) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public ObjectArrayAssert isNotEqualTo(Object[] array) {
        if (Arrays.equals((Object[])this.actual, array)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, array));
        }
        return this;
    }

    public ObjectArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((Object[])this.actual).length;
    }

    public ObjectArrayAssert isSameAs(Object[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ObjectArrayAssert isNotSameAs(Object[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }
}

