/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.PrimitiveAssert;
import org.fest.assertions.PrimitiveFail;

public final class LongAssert
extends PrimitiveAssert {
    private static final long ZERO = 0L;
    private final long actual;

    LongAssert(long actual) {
        this.actual = actual;
    }

    public LongAssert as(String description) {
        return (LongAssert)this.description(description);
    }

    public LongAssert describedAs(String description) {
        return this.as(description);
    }

    public LongAssert isEqualTo(long expected) {
        PrimitiveFail.failIfNotEqual(this.description(), this.actual, expected);
        return this;
    }

    public LongAssert isNotEqualTo(long value) {
        PrimitiveFail.failIfEqual(this.description(), this.actual, value);
        return this;
    }

    public LongAssert isGreaterThan(long value) {
        PrimitiveFail.failIfNotGreaterThan(this.description(), this.actual, value);
        return this;
    }

    public LongAssert isLessThan(long value) {
        PrimitiveFail.failIfNotLessThan(this.description(), this.actual, value);
        return this;
    }

    public LongAssert isGreaterThanOrEqualTo(long value) {
        PrimitiveFail.failIfNotGreaterThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public LongAssert isLessThanOrEqualTo(long value) {
        PrimitiveFail.failIfNotLessThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public LongAssert isPositive() {
        return this.isGreaterThan(0L);
    }

    public LongAssert isNegative() {
        return this.isLessThan(0L);
    }

    public LongAssert isZero() {
        return this.isEqualTo(0L);
    }
}

