/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.runner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.fest.reflect.core.Reflection;
import org.fest.reflect.exception.ReflectionError;
import org.fest.swing.junit.runner.FailedGUITestListener;
import org.fest.swing.junit.runner.GUITestDescription;
import org.fest.util.CollectionFilter;
import org.fest.util.Collections;
import org.fest.util.TypeFilter;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.runners.BeforeAndAfterRunner;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestIntrospector;
import org.junit.internal.runners.TestMethodRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUITestRunner
extends Runner {
    private static final List<RunListener> NO_LISTENERS = new ArrayList<RunListener>();
    private final List<Method> testMethods;
    private final Class<?> testClass;

    public GUITestRunner(Class<?> testClass) throws InitializationError {
        this.testClass = testClass;
        this.testMethods = new TestIntrospector(testClass).getTestMethods(Test.class);
        this.validate();
    }

    private void validate() throws InitializationError {
        MethodValidator methodValidator = new MethodValidator(this.testClass);
        methodValidator.validateMethodsForDefaultRunner();
        methodValidator.assertValid();
    }

    public void run(RunNotifier notifier) {
        this.addFailedGUITestListenerTo(notifier);
        new InnerRunner(notifier).runProtected();
        this.removeFailedGUITestListenersFrom(notifier);
    }

    private void addFailedGUITestListenerTo(RunNotifier notifier) {
        if (!this.failedGUITestListenersIn(notifier).isEmpty()) {
            return;
        }
        notifier.addListener((RunListener)new FailedGUITestListener());
    }

    private void removeFailedGUITestListenersFrom(RunNotifier notifier) {
        for (RunListener runListener : this.failedGUITestListenersIn(notifier)) {
            notifier.removeListener(runListener);
        }
    }

    private List<? extends RunListener> failedGUITestListenersIn(RunNotifier notifier) {
        List<RunListener> listeners = this.listenersIn(notifier);
        if (listeners.isEmpty()) {
            return NO_LISTENERS;
        }
        return Collections.filter(listeners, (CollectionFilter)TypeFilter.byType(FailedGUITestListener.class));
    }

    private List<RunListener> listenersIn(RunNotifier notifier) {
        try {
            return (List)Reflection.field((String)"fListeners").ofType(List.class).in((Object)notifier).get();
        }
        catch (ReflectionError e) {
            return NO_LISTENERS;
        }
    }

    final void doRun(RunNotifier notifier) {
        if (this.testMethods.isEmpty()) {
            notifier.testAborted(this.getDescription(), (Throwable)new Exception("No runnable methods"));
        }
        for (Method method : this.testMethods) {
            this.invokeTestMethod(method, notifier);
        }
    }

    private void invokeTestMethod(Method method, RunNotifier notifier) {
        Object test;
        try {
            test = this.testClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            notifier.testAborted(this.methodDescription(method), e.getCause());
            return;
        }
        catch (Exception e) {
            notifier.testAborted(this.methodDescription(method), (Throwable)e);
            return;
        }
        this.createMethodRunner(test, method, notifier).run();
    }

    private TestMethodRunner createMethodRunner(Object test, Method method, RunNotifier notifier) {
        return new TestMethodRunner(test, method, notifier, this.methodDescription(method));
    }

    final Class<?> testClass() {
        return this.testClass;
    }

    public Description getDescription() {
        Description spec = Description.createSuiteDescription((String)this.testClass.getName());
        for (Method method : this.testMethods) {
            spec.addChild(this.methodDescription(method));
        }
        return spec;
    }

    private Description methodDescription(Method method) {
        return new GUITestDescription(this.testClass, method);
    }

    private class InnerRunner
    extends BeforeAndAfterRunner {
        private final RunNotifier notifier;

        InnerRunner(RunNotifier notifier) {
            super(GUITestRunner.this.testClass(), BeforeClass.class, AfterClass.class, null);
            this.notifier = notifier;
        }

        protected void runUnprotected() {
            GUITestRunner.this.doRun(this.notifier);
        }

        protected void addFailure(Throwable targetException) {
            this.notifier.fireTestFailure(new Failure(GUITestRunner.this.getDescription(), targetException));
        }
    }
}

