/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.runner;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fest.swing.image.ScreenshotTaker;
import org.fest.swing.junit.runner.Formatter;
import org.fest.swing.junit.runner.GUITestDescription;
import org.fest.util.Files;
import org.fest.util.FilesException;
import org.fest.util.Strings;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class FailedGUITestListener
extends RunListener {
    private static final String FAILED_GUI_TESTS_FOLDER = "failed-gui-tests";
    private static Logger logger = Logger.getLogger(FailedGUITestListener.class.getName());
    private final ScreenshotTaker screenshotTaker = new ScreenshotTaker();
    private File images;

    public FailedGUITestListener() {
        try {
            this.images = FailedGUITestListener.imageFolder();
        }
        catch (FilesException e) {
            logger.log(Level.INFO, "Unable to take screenshots for failing GUI tests", e);
        }
    }

    private static File imageFolder() {
        try {
            File images = new File(Strings.concat((Object[])new Object[]{Files.currentFolder().getCanonicalPath(), File.separator, FAILED_GUI_TESTS_FOLDER}));
            Files.delete((File)images);
            images.mkdir();
            return images;
        }
        catch (IOException e) {
            throw new FilesException(Strings.concat((Object[])new Object[]{"Unable to create directory ", Strings.quote((String)FAILED_GUI_TESTS_FOLDER)}), (Throwable)e);
        }
    }

    public void testFailure(Failure failure) throws Exception {
        this.takeScreenshot(failure);
        super.testFailure(failure);
    }

    private void takeScreenshot(Failure failure) {
        if (this.images == null) {
            return;
        }
        GUITestDescription description = this.descriptionForGUITest(failure);
        if (description == null) {
            return;
        }
        String methodSignature = Formatter.format(description.testClass(), description.testMethod());
        try {
            String fileName = Strings.concat((Object[])new Object[]{this.images.getCanonicalPath(), File.separator, methodSignature, ".", "png"});
            this.screenshotTaker.saveDesktopAsPng(fileName);
            logger.info(Strings.concat((Object[])new Object[]{"Screenshot of failed test saved as ", Strings.quote((String)fileName)}));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, Strings.concat((Object[])new Object[]{"Unable to take screenshot of failed test ", Strings.quote((String)methodSignature)}), e);
        }
    }

    private GUITestDescription descriptionForGUITest(Failure failure) {
        Description description = failure.getDescription();
        if (!(description instanceof GUITestDescription)) {
            return null;
        }
        GUITestDescription guiTestDescription = (GUITestDescription)description;
        if (!guiTestDescription.isGUITest()) {
            return null;
        }
        return guiTestDescription;
    }
}

