/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.ant;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.fest.util.Files;
import org.fest.util.Strings;

public final class ImageHandler {
    private static final String UTF_8 = "UTF-8";
    private static final String EMPTY_STRING = "";
    private static Logger logger = Logger.getAnonymousLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeBase64(BufferedImage image) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", out);
            byte[] encoded = Base64.encodeBase64((byte[])out.toByteArray());
            String string = new String(encoded, UTF_8);
            return string;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to encode image", e);
            String string = null;
            return string;
        }
        finally {
            Files.flushAndClose((OutputStream)out);
        }
    }

    public static BufferedImage decodeBase64(String encoded) {
        ByteArrayInputStream in = null;
        try {
            byte[] toDecode = encoded.getBytes(UTF_8);
            in = new ByteArrayInputStream(Base64.decodeBase64((byte[])toDecode));
            return ImageIO.read(in);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to decode image", e);
            return null;
        }
    }

    public static String decodeBase64AndSaveAsPng(String encoded, String imageFilePath) {
        if (Strings.isEmpty((String)encoded)) {
            return EMPTY_STRING;
        }
        if (Strings.isEmpty((String)imageFilePath)) {
            return EMPTY_STRING;
        }
        String realPath = imageFilePath.replace("/", File.separator);
        BufferedImage image = ImageHandler.decodeBase64(encoded);
        File newFile = new File(realPath);
        if (newFile.exists()) {
            return EMPTY_STRING;
        }
        try {
            newFile = Files.newFile((String)realPath);
            ImageIO.write((RenderedImage)image, "png", newFile);
        }
        catch (Exception ignored) {
            logger.log(Level.WARNING, ignored.getMessage());
        }
        return EMPTY_STRING;
    }

    private ImageHandler() {
    }
}

