/*
* Licensed to the Apache Software Foundation (ASF) under one or more
*  contributor license agreements.  The ASF licenses this file to You
* under the Apache License, Version 2.0 (the "License"); you may not
* use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.  For additional information regarding
* copyright in this work, please see the NOTICE file in the top level
* directory of this distribution.
*/
package org.apache.roller.weblogger.ui.core.security;

import org.acegisecurity.AuthenticationException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.cas.CasAuthoritiesPopulator;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.apache.log4j.Logger;

/**
 * An implementation of CasAuthoritiesPopulator that uses a UserDetailsService to retrieve
 * User object from RollerDB. 
 * 
 * @author Phillip Rhodes (<a href="mailto:mindcrime@cpphacker.co.uk">mindcrime@cpphacker.co.uk</a>)
 */
public class RollerCasPopulator implements CasAuthoritiesPopulator {
    private static final Logger logger = Logger.getLogger(RollerCasPopulator.class);
    private UserDetailsService userDetailsService;

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public UserDetails getUserDetails(String userName) throws AuthenticationException {
        User userObject = (User) userDetailsService.loadUserByUsername(userName);

        // in  a more sophisticated implementation we would look up and insert
        // GrantedAuthoritys here.

        return userObject;
    }
}