/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ojb;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.query.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.ojb.OjbAccessor;
import org.springframework.orm.ojb.OjbFactoryUtils;
import org.springframework.orm.ojb.PersistenceBrokerCallback;
import org.springframework.orm.ojb.PersistenceBrokerOperations;

public class PersistenceBrokerTemplate
extends OjbAccessor
implements PersistenceBrokerOperations {
    private boolean allowCreate = true;

    public PersistenceBrokerTemplate() {
    }

    public PersistenceBrokerTemplate(boolean allowCreate) {
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public PersistenceBrokerTemplate(PBKey pbKey) {
        this.setPbKey(pbKey);
        this.afterPropertiesSet();
    }

    public PersistenceBrokerTemplate(PBKey pbKey, boolean allowCreate) {
        this.setPbKey(pbKey);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public Object execute(PersistenceBrokerCallback action) throws DataAccessException {
        PersistenceBroker pb = this.getPersistenceBroker();
        try {
            Object object = action.doInPersistenceBroker(pb);
            return object;
        }
        catch (PersistenceBrokerException ex) {
            throw this.convertOjbAccessException(ex);
        }
        catch (LookupException ex) {
            throw new DataAccessResourceFailureException("Could not retrieve resource", ex);
        }
        catch (SQLException ex) {
            throw this.convertJdbcAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            this.releasePersistenceBroker(pb);
        }
    }

    public Collection executeFind(PersistenceBrokerCallback action) throws DataAccessException {
        Object result = this.execute(action);
        if (result != null && !(result instanceof Collection)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from PersistenceBrokerCallback isn't a Collection: [" + result + "]");
        }
        return (Collection)result;
    }

    public Object getObjectById(final Class entityClass, final Object idValue) throws DataAccessException {
        return this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                Identity id = pb.serviceIdentity().buildIdentity(entityClass, idValue);
                Object result = pb.getObjectByIdentity(id);
                if (result == null) {
                    throw new ObjectRetrievalFailureException(entityClass, idValue);
                }
                return result;
            }
        });
    }

    public Object getObjectByQuery(final Query query) throws DataAccessException {
        return this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                return pb.getObjectByQuery(query);
            }
        });
    }

    public Collection getCollectionByQuery(final Query query) throws DataAccessException {
        return this.executeFind(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                return pb.getCollectionByQuery(query);
            }
        });
    }

    public Iterator getIteratorByQuery(final Query query) throws DataAccessException {
        return (Iterator)this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                return pb.getIteratorByQuery(query);
            }
        });
    }

    public Iterator getReportQueryIteratorByQuery(final Query query) {
        return (Iterator)this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                return pb.getReportQueryIteratorByQuery(query);
            }
        });
    }

    public int getCount(final Query query) throws DataAccessException {
        Integer count = (Integer)this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                return new Integer(pb.getCount(query));
            }
        });
        return count;
    }

    public void removeFromCache(final Object entityOrId) throws DataAccessException {
        this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                pb.removeFromCache(entityOrId);
                return null;
            }
        });
    }

    public void clearCache() throws DataAccessException {
        this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                pb.clearCache();
                return null;
            }
        });
    }

    public void store(final Object entity) throws DataAccessException {
        this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                pb.store(entity);
                return null;
            }
        });
    }

    public void delete(final Object entity) throws DataAccessException {
        this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                pb.delete(entity);
                return null;
            }
        });
    }

    public void deleteByQuery(final Query query) throws DataAccessException {
        this.execute(new PersistenceBrokerCallback(){

            public Object doInPersistenceBroker(PersistenceBroker pb) throws PersistenceBrokerException {
                pb.deleteByQuery(query);
                return null;
            }
        });
    }

    protected PersistenceBroker getPersistenceBroker() throws DataAccessResourceFailureException, IllegalStateException {
        return OjbFactoryUtils.getPersistenceBroker(this.getPbKey(), this.isAllowCreate());
    }

    protected void releasePersistenceBroker(PersistenceBroker pb) {
        OjbFactoryUtils.releasePersistenceBroker(pb, this.getPbKey());
    }
}

