/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity;

import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.providers.AbstractAuthenticationToken;

public abstract class AbstractAuthenticationManager
implements AuthenticationManager {
    public final Authentication authenticate(Authentication authRequest) throws AuthenticationException {
        try {
            Authentication authResult = this.doAuthentication(authRequest);
            this.copyDetails(authRequest, authResult);
            return authResult;
        }
        catch (AuthenticationException e) {
            e.setAuthentication(authRequest);
            throw e;
        }
    }

    private void copyDetails(Authentication source, Authentication dest) {
        if (dest instanceof AbstractAuthenticationToken && dest.getDetails() == null) {
            AbstractAuthenticationToken token = (AbstractAuthenticationToken)dest;
            token.setDetails(source.getDetails());
        }
    }

    protected abstract Authentication doAuthentication(Authentication var1) throws AuthenticationException;
}

