/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class MultiClassLoader
extends ClassLoader {
    public static final ClassLoader THREAD_LOADER = null;
    public static final ClassLoader SYSTEM_LOADER = ClassLoader.getSystemClassLoader();
    private List _loaders = new ArrayList(5);

    public MultiClassLoader() {
        super(null);
    }

    public MultiClassLoader(MultiClassLoader other) {
        super(null);
        this.addClassLoaders(other);
    }

    public boolean containsClassLoader(ClassLoader loader) {
        return this._loaders.contains(loader);
    }

    public ClassLoader[] getClassLoaders() {
        ClassLoader[] loaders = new ClassLoader[this.size()];
        Iterator itr = this._loaders.iterator();
        for (int i = 0; i < loaders.length; ++i) {
            ClassLoader loader = (ClassLoader)itr.next();
            if (loader == THREAD_LOADER) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            loaders[i] = loader;
        }
        return loaders;
    }

    public ClassLoader getClassLoader(int index) {
        ClassLoader loader = (ClassLoader)this._loaders.get(index);
        if (loader == THREAD_LOADER) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    public boolean addClassLoader(ClassLoader loader) {
        if (this._loaders.contains(loader)) {
            return false;
        }
        return this._loaders.add(loader);
    }

    public boolean addClassLoader(int index, ClassLoader loader) {
        if (this._loaders.contains(loader)) {
            return false;
        }
        this._loaders.add(index, loader);
        return true;
    }

    public void setClassLoaders(MultiClassLoader multi) {
        this.clear();
        this.addClassLoaders(multi);
    }

    public boolean addClassLoaders(int index, MultiClassLoader multi) {
        if (multi == null) {
            return false;
        }
        boolean added = false;
        Iterator itr = multi._loaders.iterator();
        while (itr.hasNext()) {
            if (!this.addClassLoader(index, (ClassLoader)itr.next())) continue;
            ++index;
            added = true;
        }
        return added;
    }

    public boolean addClassLoaders(MultiClassLoader multi) {
        if (multi == null) {
            return false;
        }
        boolean added = false;
        Iterator itr = multi._loaders.iterator();
        while (itr.hasNext()) {
            added = this.addClassLoader((ClassLoader)itr.next()) || added;
        }
        return added;
    }

    public boolean removeClassLoader(ClassLoader loader) {
        return this._loaders.remove(loader);
    }

    public void clear() {
        this._loaders.clear();
    }

    public int size() {
        return this._loaders.size();
    }

    public boolean isEmpty() {
        return this._loaders.isEmpty();
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Iterator itr = this._loaders.iterator();
        while (itr.hasNext()) {
            ClassLoader loader = (ClassLoader)itr.next();
            if (loader == THREAD_LOADER) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            try {
                return Class.forName(name, false, loader);
            }
            catch (Throwable t) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    protected URL findResource(String name) {
        Iterator itr = this._loaders.iterator();
        while (itr.hasNext()) {
            URL rsrc;
            ClassLoader loader = (ClassLoader)itr.next();
            if (loader == THREAD_LOADER) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            if (loader == null || (rsrc = loader.getResource(name)) == null) continue;
            return rsrc;
        }
        return null;
    }

    protected Enumeration findResources(String name) throws IOException {
        Vector<URL> all = new Vector<URL>();
        Iterator itr = this._loaders.iterator();
        while (itr.hasNext()) {
            ClassLoader loader = (ClassLoader)itr.next();
            if (loader == THREAD_LOADER) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            Enumeration<URL> rsrcs = loader.getResources(name);
            while (rsrcs.hasMoreElements()) {
                URL rsrc = rsrcs.nextElement();
                if (all.contains(rsrc)) continue;
                all.addElement(rsrc);
            }
        }
        return all.elements();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiClassLoader)) {
            return false;
        }
        return ((Object)((MultiClassLoader)other)._loaders).equals(this._loaders);
    }

    public int hashCode() {
        return ((Object)this._loaders).hashCode();
    }
}

