/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.lang.reflect.Modifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.MappingInfo;
import org.apache.openjpa.jdbc.meta.strats.SuperclassDiscriminatorStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.MetaDataException;

public class DiscriminatorMappingInfo
extends MappingInfo {
    private static final Localizer _loc = Localizer.forPackage(DiscriminatorMappingInfo.class);
    private String _value = null;

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public Object getValue(Discriminator discrim, boolean adapt) {
        if (discrim.getValue() != null) {
            return discrim.getValue();
        }
        if (this._value == null) {
            return discrim.getMappingRepository().getMappingDefaults().getDiscriminatorValue(discrim, adapt);
        }
        if (this._value.length() > 0 && (this._value.charAt(0) == '-' || Character.isDigit(this._value.charAt(0)))) {
            try {
                if (this._value.indexOf(46) == -1) {
                    return new Integer(this._value);
                }
                return new Double(this._value);
            }
            catch (RuntimeException re) {
                throw new MetaDataException(_loc.get("bad-discrim-value", discrim.getClassMapping(), this._value));
            }
        }
        if ("null".equalsIgnoreCase(this._value)) {
            return Discriminator.NULL;
        }
        if (this._value.length() > 0 && this._value.charAt(0) == '\'') {
            return this._value.substring(1, this._value.length() - 1);
        }
        return this._value;
    }

    public Column[] getColumns(Discriminator discrim, Column[] tmplates, boolean adapt) {
        Table table = discrim.getClassMapping().getTable();
        discrim.getMappingRepository().getMappingDefaults().populateColumns(discrim, table, tmplates);
        return this.createColumns(discrim, null, tmplates, table, adapt);
    }

    public Index getIndex(Discriminator discrim, Column[] cols, boolean adapt) {
        Index idx = null;
        if (cols.length > 0) {
            idx = discrim.getMappingRepository().getMappingDefaults().getIndex(discrim, cols[0].getTable(), cols);
        }
        return this.createIndex(discrim, null, idx, cols, adapt);
    }

    public void syncWith(Discriminator disc) {
        this.clear(false);
        this.setColumnIO(disc.getColumnIO());
        this.syncColumns(disc, disc.getColumns(), disc.getValue() != null && !(disc.getValue() instanceof String));
        this.syncIndex(disc, disc.getIndex());
        if (disc.getValue() == Discriminator.NULL) {
            this._value = "null";
        } else if (disc.getValue() != null) {
            this._value = disc.getValue().toString();
        }
        if (disc.getStrategy() == null || disc.getStrategy() instanceof SuperclassDiscriminatorStrategy) {
            return;
        }
        ClassMapping cls = disc.getClassMapping();
        String strat = disc.getStrategy().getAlias();
        boolean sync = false;
        if (!cls.isMapped() || cls.getJoinablePCSuperclassMapping() != null && Modifier.isFinal(cls.getDescribedType().getModifiers()) || cls.getJoinablePCSuperclassMapping() == null && cls.getMappedPCSuperclassMapping() != null) {
            sync = !"none".equals(strat);
        } else {
            boolean bl = sync = cls.getJoinablePCSuperclassMapping() != null || this._value == null || !"value-map".equals(strat);
        }
        if (sync) {
            this.setStrategy(strat);
        }
    }

    protected void clear(boolean canFlags) {
        super.clear(canFlags);
        this._value = null;
    }

    public void copy(MappingInfo info) {
        super.copy(info);
        if (!(info instanceof DiscriminatorMappingInfo)) {
            return;
        }
        if (this._value == null) {
            this._value = ((DiscriminatorMappingInfo)info).getValue();
        }
    }
}

