/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.CallableStatement;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.DatabaseMetaData;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ProductLevel;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCallableStatement;
import org.apache.derby.client.net.NetConfiguration;
import org.apache.derby.client.net.NetDatabaseMetaData;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetPreparedStatement;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.NetXAResource;
import org.apache.derby.client.net.OpenSocketAction;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDataSource;

public class NetConnection
extends Connection {
    protected NetAgent netAgent_;
    protected int pendingEndXACallinfoOffset_ = -1;
    protected byte[] cachedConnectBytes_ = null;
    protected boolean wroteConnectFromCache_ = false;
    protected int targetAgent_ = 7;
    protected int targetCmntcpip_ = 5;
    protected int targetRdb_ = 7;
    public int targetSecmgr_ = 7;
    protected int targetCmnappc_ = 0;
    protected int targetXamgr_ = 7;
    protected int targetSyncptmgr_ = 0;
    protected int targetRsyncmgr_ = 0;
    String targetExtnam_;
    String extnam_;
    public String targetSrvclsnm_;
    protected String targetSrvnam_;
    public String targetSrvrlslv_;
    transient byte[] publicKey_;
    transient byte[] targetPublicKey_;
    byte[] prddta_;
    public byte[] crrtkn_;
    int targetSecmec_;
    protected int securityMechanism_;
    private transient char[] deferredResetPassword_ = null;
    protected byte[] cnntkn_ = null;
    private int rmId_ = 0;
    protected NetXAResource xares_ = null;
    protected Hashtable indoubtTransactions_ = null;
    protected int currXACallInfoOffset_ = 0;
    private short seqNo_ = 1;
    protected boolean readOnlyTransaction_ = true;

    private void setDeferredResetPassword(String string) {
        this.deferredResetPassword_ = string == null ? null : this.flipBits(string.toCharArray());
    }

    private String getDeferredResetPassword() {
        if (this.deferredResetPassword_ == null) {
            return null;
        }
        String string = new String(this.flipBits(this.deferredResetPassword_));
        this.flipBits(this.deferredResetPassword_);
        return string;
    }

    public NetConnection(NetLogWriter netLogWriter, String string, Properties properties) throws SqlException {
        super(netLogWriter, 0, "", -1, string, properties);
    }

    public NetConnection(NetLogWriter netLogWriter, ClientDataSource clientDataSource, String string, String string2) throws SqlException {
        super(netLogWriter, string, string2, clientDataSource);
        this.setDeferredResetPassword(string2);
    }

    public NetConnection(NetLogWriter netLogWriter, int n, String string, int n2, String string2, Properties properties) throws SqlException {
        super(netLogWriter, n, string, n2, string2, properties);
        this.netAgent_ = (NetAgent)this.agent_;
        if (this.netAgent_.exceptionOpeningSocket_ != null) {
            throw this.netAgent_.exceptionOpeningSocket_;
        }
        this.checkDatabaseName();
        String string3 = ClientDataSource.getPassword(properties);
        this.securityMechanism_ = ClientDataSource.getSecurityMechanism(properties);
        this.flowConnect(string3, this.securityMechanism_);
        this.completeConnect();
    }

    public NetConnection(NetLogWriter netLogWriter, String string, String string2, ClientDataSource clientDataSource, int n, boolean bl) throws SqlException {
        super(netLogWriter, string, string2, bl, clientDataSource);
        this.netAgent_ = (NetAgent)this.agent_;
        this.initialize(string, string2, clientDataSource, n, bl);
    }

    public NetConnection(NetLogWriter netLogWriter, String string, int n, ClientDataSource clientDataSource, boolean bl) throws SqlException {
        super(netLogWriter, bl, clientDataSource);
        this.netAgent_ = (NetAgent)this.agent_;
        if (this.netAgent_.exceptionOpeningSocket_ != null) {
            throw this.netAgent_.exceptionOpeningSocket_;
        }
        this.checkDatabaseName();
        this.isXAConnection_ = bl;
        this.flowSimpleConnect();
        this.productID_ = this.targetSrvrlslv_;
        super.completeConnect();
    }

    private void initialize(String string, String string2, ClientDataSource clientDataSource, int n, boolean bl) throws SqlException {
        this.securityMechanism_ = clientDataSource.getSecurityMechanism();
        this.setDeferredResetPassword(string2);
        this.checkDatabaseName();
        this.dataSource_ = clientDataSource;
        this.rmId_ = n;
        this.isXAConnection_ = bl;
        this.flowConnect(string2, this.securityMechanism_);
        this.completeConnect();
    }

    public void resetNetConnection(LogWriter logWriter, String string, String string2, ClientDataSource clientDataSource, boolean bl) throws SqlException {
        super.resetConnection(logWriter, string, clientDataSource, bl);
        if (bl) {
            this.targetExtnam_ = null;
            this.targetSrvclsnm_ = null;
            this.targetSrvnam_ = null;
            this.targetSrvrlslv_ = null;
            this.publicKey_ = null;
            this.targetPublicKey_ = null;
            this.targetSecmec_ = 0;
            if (clientDataSource != null && this.securityMechanism_ == 0) {
                this.securityMechanism_ = clientDataSource.getSecurityMechanism();
            }
            this.resetConnectionAtFirstSql_ = false;
            if (this.resultSetHoldability_ == 0) {
                ((NetDatabaseMetaData)this.databaseMetaData_).setDefaultResultSetHoldability();
            }
        }
        if (string2 != null) {
            this.deferredResetPassword_ = null;
        } else {
            string2 = this.getDeferredResetPassword();
        }
        boolean bl2 = this.flowReconnect(string2, this.securityMechanism_);
        this.completeReset(bl2, bl);
    }

    protected void reset_(LogWriter logWriter, String string, String string2, ClientDataSource clientDataSource, boolean bl) throws SqlException {
        this.checkResetPreconditions(logWriter, string, string2, clientDataSource);
        this.resetNetConnection(logWriter, string, string2, clientDataSource, bl);
    }

    protected void reset_(LogWriter logWriter, ClientDataSource clientDataSource, boolean bl) throws SqlException {
        this.checkResetPreconditions(logWriter, null, null, clientDataSource);
        this.resetNetConnection(logWriter, clientDataSource, bl);
    }

    private void resetNetConnection(LogWriter logWriter, ClientDataSource clientDataSource, boolean bl) throws SqlException {
        super.resetConnection(logWriter, null, clientDataSource, bl);
        if (bl) {
            this.targetExtnam_ = null;
            this.targetSrvclsnm_ = null;
            this.targetSrvnam_ = null;
            this.targetSrvrlslv_ = null;
            this.publicKey_ = null;
            this.targetPublicKey_ = null;
            this.targetSecmec_ = 0;
            if (clientDataSource != null && this.securityMechanism_ == 0) {
                this.securityMechanism_ = clientDataSource.getSecurityMechanism();
            }
            this.resetConnectionAtFirstSql_ = false;
            if (this.resultSetHoldability_ == 0) {
                ((NetDatabaseMetaData)this.databaseMetaData_).setDefaultResultSetHoldability();
            }
        }
        boolean bl2 = this.flowReconnect(null, this.securityMechanism_);
        this.completeReset(bl2, bl);
    }

    protected void checkResetPreconditions(LogWriter logWriter, String string, String string2, ClientDataSource clientDataSource) throws SqlException {
        if (this.inUnitOfWork_) {
            throw new SqlException(logWriter, "Connection reset is not allowed when inside a unit of work.");
        }
    }

    List getSpecialRegisters() {
        if (this.xares_ != null) {
            return this.xares_.getSpecialRegisters();
        }
        return null;
    }

    public void addSpecialRegisters(String string) {
        if (this.xares_ != null) {
            this.xares_.addSpecialRegisters(string);
        }
    }

    public void completeConnect() throws SqlException {
        super.completeConnect();
    }

    protected void completeReset(boolean bl, boolean bl2) throws SqlException {
        super.completeReset(bl, bl2);
    }

    public void flowConnect(String string, int n) throws SqlException {
        this.netAgent_ = (NetAgent)this.agent_;
        this.constructExtnam();
        this.constructPrddta();
        this.netAgent_.typdef_ = new Typdef(this.netAgent_, 1208, "QTDSQLASC", 1200, 1208);
        this.netAgent_.originalTargetTypdef_ = this.netAgent_.targetTypdef_ = new Typdef(this.netAgent_);
        this.setDeferredResetPassword(string);
        n = ClientBaseDataSource.getUpgradedSecurityMechanism((short)n, string);
        try {
            switch (n) {
                case 3: {
                    this.checkUserPassword(this.user_, string);
                    this.flowUSRIDPWDconnect(string);
                    break;
                }
                case 4: {
                    this.checkUser(this.user_);
                    this.flowUSRIDONLconnect();
                    break;
                }
                case 7: {
                    this.checkUserPassword(this.user_, string);
                    this.flowUSRENCPWDconnect(string);
                    break;
                }
                case 9: {
                    this.checkUserPassword(this.user_, string);
                    this.flowEUSRIDPWDconnect(string);
                    break;
                }
                case 12: {
                    this.checkUserPassword(this.user_, string);
                    this.flowEUSRIDDTAconnect();
                    break;
                }
                case 13: {
                    this.checkUserPassword(this.user_, string);
                    this.flowEUSRPWDDTAconnect(string);
                    break;
                }
                default: {
                    throw new SqlException(this.agent_.logWriter_, "security mechanism '" + n + "' not supported");
                }
            }
        }
        catch (Throwable throwable) {
            this.open_ = false;
            SqlException sqlException = throwable instanceof SqlException ? (SqlException)throwable : new SqlException(this.agent_.logWriter_, throwable, "Unexpected throwable caught " + throwable.toString());
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException2) {
                // empty catch block
            }
            throw sqlException;
        }
    }

    protected void flowSimpleConnect() throws SqlException {
        this.netAgent_ = (NetAgent)this.agent_;
        this.constructExtnam();
        this.constructPrddta();
        this.netAgent_.typdef_ = new Typdef(this.netAgent_, 1208, "QTDSQLASC", 1200, 1208);
        this.netAgent_.originalTargetTypdef_ = this.netAgent_.targetTypdef_ = new Typdef(this.netAgent_);
        try {
            this.flowServerAttributes();
        }
        catch (Throwable throwable) {
            this.open_ = false;
            SqlException sqlException = throwable instanceof SqlException ? (SqlException)throwable : new SqlException(this.agent_.logWriter_, throwable, "Unexpected throwable caught " + throwable.toString());
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException2) {
                // empty catch block
            }
            throw sqlException;
        }
    }

    protected boolean flowReconnect(String string, int n) throws SqlException {
        this.constructExtnam();
        this.constructPrddta();
        this.checkSecmgrForSecmecSupport(n);
        try {
            switch (n) {
                case 3: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
                case 4: {
                    this.checkUser(this.user_);
                    this.resetConnectionAtFirstSql_ = true;
                    return true;
                }
                case 7: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
                case 9: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
                case 12: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
                case 13: {
                    this.checkUserPassword(this.user_, string);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(string);
                    return true;
                }
            }
            throw new SqlException(this.agent_.logWriter_, "security mechanism '" + n + "' not supported");
        }
        catch (SqlException sqlException) {
            this.open_ = false;
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException2) {
                // empty catch block
            }
            throw sqlException;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected byte[] getCnnToken() {
        return this.cnntkn_;
    }

    protected short getSequenceNumber() {
        this.seqNo_ = (short)(this.seqNo_ + 1);
        return this.seqNo_;
    }

    private void flowUSRIDPWDconnect(String string) throws SqlException {
        this.flowServerAttributesAndKeyExchange(3, null);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, string, null, null);
    }

    private void flowUSRIDONLconnect() throws SqlException {
        this.flowServerAttributesAndKeyExchange(4, null);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, null);
    }

    private void flowUSRENCPWDconnect(String string) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(7);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(7, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, this.encryptedPasswordForUSRENCPWD(string));
    }

    private void flowEUSRIDPWDconnect(String string) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(9);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(9, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(string));
    }

    private void flowEUSRIDDTAconnect() throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(9);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(12, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), null);
    }

    private void flowEUSRPWDDTAconnect(String string) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(13);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(13, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(string));
    }

    private void flowServerAttributes() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeExchangeServerAttributes(this.extnam_, this.targetAgent_, this.netAgent_.targetSqlam_, this.targetRdb_, this.targetSecmgr_, this.targetCmntcpip_, this.targetCmnappc_, this.targetXamgr_, this.targetSyncptmgr_, this.targetRsyncmgr_);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readExchangeServerAttributes(this);
        this.agent_.endReadChain();
    }

    private void flowKeyExchange(int n, byte[] byArray) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(n, this.databaseName_, byArray);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, n);
        this.agent_.endReadChain();
    }

    private void flowServerAttributesAndKeyExchange(int n, byte[] byArray) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeServerAttributesAndKeyExchange(n, byArray);
        this.agent_.flowOutsideUOW();
        this.readServerAttributesAndKeyExchange(n);
        this.agent_.endReadChain();
    }

    private void flowSecurityCheckAndAccessRdb(int n, String string, String string2, byte[] byArray, byte[] byArray2) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeSecurityCheckAndAccessRdb(n, string, string2, byArray, byArray2);
        this.agent_.flowOutsideUOW();
        this.readSecurityCheckAndAccessRdb();
        this.agent_.endReadChain();
    }

    private void writeAllConnectCommandsChained(int n, String string, String string2) throws SqlException {
        this.writeServerAttributesAndKeyExchange(n, null);
        this.writeSecurityCheckAndAccessRdb(n, string, string2, null, null);
    }

    private void readAllConnectCommandsChained(int n) throws SqlException {
        this.readServerAttributesAndKeyExchange(n);
        this.readSecurityCheckAndAccessRdb();
    }

    private void writeServerAttributesAndKeyExchange(int n, byte[] byArray) throws SqlException {
        this.netAgent_.netConnectionRequest_.writeExchangeServerAttributes(this.extnam_, this.targetAgent_, this.netAgent_.targetSqlam_, this.targetRdb_, this.targetSecmgr_, this.targetCmntcpip_, this.targetCmnappc_, this.targetXamgr_, this.targetSyncptmgr_, this.targetRsyncmgr_);
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(n, this.databaseName_, byArray);
    }

    private void readServerAttributesAndKeyExchange(int n) throws SqlException {
        this.netAgent_.netConnectionReply_.readExchangeServerAttributes(this);
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, n);
    }

    private void writeSecurityCheckAndAccessRdb(int n, String string, String string2, byte[] byArray, byte[] byArray2) throws SqlException {
        this.netAgent_.netConnectionRequest_.writeSecurityCheck(n, this.databaseName_, string, string2, byArray, byArray2);
        this.netAgent_.netConnectionRequest_.writeAccessDatabase(this.databaseName_, false, this.crrtkn_, this.prddta_, this.netAgent_.typdef_);
    }

    private void cacheConnectBytes(int n, int n2) {
        int n3 = n2 - n;
        this.cachedConnectBytes_ = new byte[n3];
        this.netAgent_.netConnectionRequest_.finalizePreviousChainedDss(false);
        System.arraycopy(this.netAgent_.netConnectionRequest_.bytes_, n, this.cachedConnectBytes_, 0, n3);
        this.netAgent_.netConnectionRequest_.setDssLengthLocation(this.netAgent_.netConnectionRequest_.offset_);
    }

    private void readSecurityCheckAndAccessRdb() throws SqlException {
        this.netAgent_.netConnectionReply_.readSecurityCheck(this);
        this.netAgent_.netConnectionReply_.readAccessDatabase(this);
    }

    void writeDeferredReset() throws SqlException {
        if (this.canUseCachedConnectBytes_ && this.cachedConnectBytes_ != null && (this.securityMechanism_ == 3 || this.securityMechanism_ == 4)) {
            this.writeDeferredResetFromCache();
            this.wroteConnectFromCache_ = true;
        } else {
            int n = this.netAgent_.netConnectionRequest_.offset_;
            int n2 = 0;
            if (this.securityMechanism_ == 3) {
                this.writeAllConnectCommandsChained(3, this.user_, this.getDeferredResetPassword());
                n2 = this.netAgent_.netConnectionRequest_.offset_;
                this.cacheConnectBytes(n, n2);
            } else if (this.securityMechanism_ == 4) {
                this.writeAllConnectCommandsChained(4, this.user_, null);
                n2 = this.netAgent_.netConnectionRequest_.offset_;
                this.cacheConnectBytes(n, n2);
            } else {
                this.initializePublicKeyForEncryption();
                this.resetConnectionAtFirstSql_ = false;
                this.flowServerAttributesAndKeyExchange(this.securityMechanism_, this.publicKey_);
                this.agent_.beginWriteChainOutsideUOW();
                this.resetConnectionAtFirstSql_ = true;
                if (this.securityMechanism_ == 7) {
                    this.writeSecurityCheckAndAccessRdb(7, this.user_, null, null, this.encryptedPasswordForUSRENCPWD(this.getDeferredResetPassword()));
                } else {
                    this.writeSecurityCheckAndAccessRdb(9, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(this.getDeferredResetPassword()));
                }
            }
        }
    }

    void readDeferredReset() throws SqlException {
        this.resetConnectionAtFirstSql_ = false;
        if (this.wroteConnectFromCache_) {
            this.netAgent_.netConnectionReply_.verifyDeferredReset();
            return;
        }
        if (this.securityMechanism_ == 3 || this.securityMechanism_ == 4) {
            this.readAllConnectCommandsChained(this.securityMechanism_);
        } else {
            this.readSecurityCheckAndAccessRdb();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectResetExit(this);
        }
    }

    void setServerAttributeData(String string, String string2, String string3, String string4) {
        this.targetExtnam_ = string;
        this.targetSrvclsnm_ = string2;
        this.targetSrvnam_ = string3;
        this.targetSrvrlslv_ = string4;
    }

    void setAccessSecurityData(int n, int n2, int[] nArray, boolean bl, byte[] byArray) throws DisconnectException {
        if (n != 0) {
            this.netAgent_.setSvrcod(CodePoint.SVRCOD_ERROR);
            this.agent_.accumulateReadException(this.mapSecchkcd(n));
        } else if (nArray.length == 1 && nArray[0] == n2) {
            this.targetSecmec_ = nArray[0];
            if (this.targetSecmec_ == 7 || this.targetSecmec_ == 9 || this.targetSecmec_ == 12 || this.targetSecmec_ == 13) {
                if (!bl) {
                    this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, "secktn was not returned "));
                } else {
                    this.targetPublicKey_ = byArray;
                    if (this.encryptionManager_ != null) {
                        this.encryptionManager_.resetSecurityKeys();
                    }
                }
            }
        } else {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, "secmec not supported"));
        }
    }

    void securityCheckComplete(int n, int n2) {
        this.netAgent_.setSvrcod(n);
        if (n2 == 0) {
            return;
        }
        this.agent_.accumulateReadException(this.mapSecchkcd(n2));
    }

    void rdbAccessed(int n, String string, boolean bl, byte[] byArray) {
        if (bl) {
            this.crrtkn_ = byArray;
        }
        this.netAgent_.setSvrcod(n);
        this.productID_ = string;
    }

    protected Agent newAgent_(LogWriter logWriter, int n, String string, int n2) throws SqlException {
        return new NetAgent(this, (NetLogWriter)logWriter, n, string, n2);
    }

    protected Statement newStatement_(int n, int n2, int n3) throws SqlException {
        return new NetStatement((NetAgent)this.netAgent_, (NetConnection)this, (int)n, (int)n2, (int)n3).statement_;
    }

    protected void resetStatement_(Statement statement, int n, int n2, int n3) throws SqlException {
        ((NetStatement)statement.materialStatement_).resetNetStatement(this.netAgent_, this, n, n2, n3);
    }

    protected PreparedStatement newPositionedUpdatePreparedStatement_(String string, Section section) throws SqlException {
        return new NetPreparedStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)string, (Section)section).preparedStatement_;
    }

    protected PreparedStatement newPreparedStatement_(String string, int n, int n2, int n3, int n4, String[] stringArray) throws SqlException {
        return new NetPreparedStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)string, (int)n, (int)n2, (int)n3, (int)n4, (String[])stringArray).preparedStatement_;
    }

    protected void resetPreparedStatement_(PreparedStatement preparedStatement, String string, int n, int n2, int n3, int n4, String[] stringArray) throws SqlException {
        ((NetPreparedStatement)preparedStatement.materialPreparedStatement_).resetNetPreparedStatement(this.netAgent_, this, string, n, n2, n3, n4, stringArray);
    }

    protected CallableStatement newCallableStatement_(String string, int n, int n2, int n3) throws SqlException {
        return new NetCallableStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)string, (int)n, (int)n2, (int)n3).callableStatement_;
    }

    protected void resetCallableStatement_(CallableStatement callableStatement, String string, int n, int n2, int n3) throws SqlException {
        ((NetCallableStatement)callableStatement.materialCallableStatement_).resetNetCallableStatement(this.netAgent_, this, string, n, n2, n3);
    }

    protected DatabaseMetaData newDatabaseMetaData_() {
        return new NetDatabaseMetaData(this.netAgent_, this);
    }

    private void checkDatabaseName() throws SqlException {
        if (this.databaseName_ == null) {
            throw new SqlException(this.agent_.logWriter_, "Required property \"databaseName\" not set");
        }
    }

    private void checkUserLength(String string) throws SqlException {
        int n = string.length();
        if (n == 0 || n > 255) {
            throw new SqlException(this.netAgent_.logWriter_, "userid length, " + n + ", is not allowed.");
        }
    }

    private void checkPasswordLength(String string) throws SqlException {
        int n = string.length();
        if (n == 0 || n > 255) {
            throw new SqlException(this.netAgent_.logWriter_, "password length, " + n + ", is not allowed.");
        }
    }

    private void checkUser(String string) throws SqlException {
        if (string == null) {
            throw new SqlException(this.netAgent_.logWriter_, "null userid not supported");
        }
        this.checkUserLength(string);
    }

    private void checkUserPassword(String string, String string2) throws SqlException {
        this.checkUser(string);
        if (string2 == null) {
            throw new SqlException(this.netAgent_.logWriter_, "null password not supported");
        }
        this.checkPasswordLength(string2);
    }

    private void checkSecmgrForSecmecSupport(int n) throws SqlException {
        boolean bl = false;
        int[] nArray = null;
        nArray = NetConfiguration.SECMGR_SECMECS;
        for (int i = 0; i < nArray.length && !bl; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
        }
        if (!bl) {
            throw new SqlException(this.agent_.logWriter_, "Security mechananism specified by app not supported by connection");
        }
    }

    private SqlException mapSecchkcd(int n) {
        if (n == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: security mechanism not supported");
            }
            case 16: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: password missing.");
            }
            case 18: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: userid missing.");
            }
            case 19: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: userid invalid.");
            }
            case 20: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: userid revoked.");
            }
            case 21: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: new password invalid.");
            }
            case 10: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: local security service non-retryable error.");
            }
            case 11: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: SECTKN missing on ACCSEC when it is required or it is invalid");
            }
            case 14: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: password expired.");
            }
            case 15: {
                return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: password invalid.");
            }
        }
        return new SqlException(this.agent_.logWriter_, "Connection authorization failure occurred.  Reason: not specified.");
    }

    protected void constructCrrtkn() throws SqlException {
        byte[] byArray = null;
        long l = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.crrtkn_ == null) {
            this.crrtkn_ = new byte[19];
        } else {
            Arrays.fill(this.crrtkn_, (byte)0);
        }
        byArray = this.netAgent_.socket_.getLocalAddress().getAddress();
        n3 = 0;
        n4 = 0;
        while (n3 < 4) {
            n = byArray[n3] < 0 ? byArray[n3] + 256 : byArray[n3];
            n2 = n >> 4 & 0xF;
            this.crrtkn_[n4] = n3 == 0 ? this.netAgent_.sourceCcsidManager_.numToSnaRequiredCrrtknChar_[n2] : this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[n2];
            n2 = n & 0xF;
            this.crrtkn_[n4 + 1] = this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[n2];
            ++n3;
            n4 += 2;
        }
        this.crrtkn_[8] = this.netAgent_.sourceCcsidManager_.dot_;
        n = this.netAgent_.socket_.getLocalPort();
        n2 = n >> 12 & 0xF;
        this.crrtkn_[9] = this.netAgent_.sourceCcsidManager_.numToSnaRequiredCrrtknChar_[n2];
        n2 = n >> 8 & 0xF;
        this.crrtkn_[10] = this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[n2];
        n2 = n >> 4 & 0xF;
        this.crrtkn_[11] = this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[n2];
        n2 = n & 0xF;
        this.crrtkn_[12] = this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[n2];
        l = System.currentTimeMillis();
        for (n3 = 0; n3 < 6; ++n3) {
            this.crrtkn_[n3 + 13] = (byte)(l >>> 40 - n3 * 8);
        }
    }

    private void constructExtnam() throws SqlException {
        this.extnam_ = "derbydnc" + Thread.currentThread().getName();
    }

    private void constructPrddta() throws SqlException {
        int n;
        int n2 = 1;
        if (this.prddta_ == null) {
            this.prddta_ = new byte[255];
        } else {
            Arrays.fill(this.prddta_, (byte)0);
        }
        for (n = 0; n < 55; ++n) {
            this.prddta_[n] = this.netAgent_.sourceCcsidManager_.space_;
        }
        n2 = this.netAgent_.sourceCcsidManager_.convertFromUCS2(NetConfiguration.PRDID, this.prddta_, n2, this.netAgent_);
        n2 = this.netAgent_.sourceCcsidManager_.convertFromUCS2("JVM               ", this.prddta_, n2, this.netAgent_);
        n = Utils.min(this.extnam_.length(), 20);
        this.netAgent_.sourceCcsidManager_.convertFromUCS2(this.extnam_.substring(0, n), this.prddta_, n2, this.netAgent_);
        n2 += 20;
        if (this.user_ != null) {
            int n3 = Utils.min(this.user_.length(), 8);
            this.netAgent_.sourceCcsidManager_.convertFromUCS2(this.user_.substring(0, n3), this.prddta_, n2, this.netAgent_);
        }
        n2 += 8;
        this.prddta_[55] = 0;
        this.prddta_[0] = (byte)(++n2 - 1);
    }

    private void initializePublicKeyForEncryption() throws SqlException {
        if (this.encryptionManager_ == null) {
            this.encryptionManager_ = new EncryptionManager(this.agent_);
        }
        this.publicKey_ = this.encryptionManager_.obtainPublicKey();
    }

    private byte[] encryptedPasswordForUSRENCPWD(String string) throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.sourceCcsidManager_.convertFromUCS2(string, this.netAgent_), 7, this.netAgent_.sourceCcsidManager_.convertFromUCS2(this.user_, this.netAgent_), this.targetPublicKey_);
    }

    private byte[] encryptedUseridForEUSRIDPWD() throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.sourceCcsidManager_.convertFromUCS2(this.user_, this.netAgent_), 9, this.targetPublicKey_, this.targetPublicKey_);
    }

    private byte[] encryptedPasswordForEUSRIDPWD(String string) throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.sourceCcsidManager_.convertFromUCS2(string, this.netAgent_), 9, this.targetPublicKey_, this.targetPublicKey_);
    }

    public int getSQLAM() {
        return this.netAgent_.targetSqlam_;
    }

    public int getAGENT() {
        return this.targetAgent_;
    }

    public int getCMNTCPIP() {
        return this.targetCmntcpip_;
    }

    public int getRDB() {
        return this.targetRdb_;
    }

    public int getSECMGR() {
        return this.targetSecmgr_;
    }

    public int getXAMGR() {
        return this.targetXamgr_;
    }

    public int getSYNCPTMGR() {
        return this.targetSyncptmgr_;
    }

    public int getRSYNCMGR() {
        return this.targetRsyncmgr_;
    }

    private char[] flipBits(char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            int n2 = n++;
            cArray[n2] = (char)(cArray[n2] ^ 0xFF);
        }
        return cArray;
    }

    private void writeDeferredResetFromCache() {
        int n = this.cachedConnectBytes_.length;
        System.arraycopy(this.cachedConnectBytes_, 0, this.netAgent_.netConnectionRequest_.bytes_, this.netAgent_.netConnectionRequest_.offset_, n);
        this.netAgent_.netConnectionRequest_.offset_ += n;
        this.netAgent_.netConnectionRequest_.setDssLengthLocation(this.netAgent_.netConnectionRequest_.offset_);
        this.netAgent_.netConnectionRequest_.setCorrelationID(4);
    }

    public void writeCommitSubstitute_() throws SqlException {
        this.netAgent_.connectionRequest_.writeCommitSubstitute(this);
    }

    public void readCommitSubstitute_() throws SqlException {
        this.netAgent_.connectionReply_.readCommitSubstitute(this);
    }

    public void writeLocalXAStart_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXAStart(this);
    }

    public void readLocalXAStart_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXAStart(this);
    }

    public void writeLocalXACommit_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXACommit(this);
    }

    public void readLocalXACommit_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXACommit(this);
    }

    public void writeLocalXARollback_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXARollback(this);
    }

    public void readLocalXARollback_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXARollback(this);
    }

    public void writeLocalCommit_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalCommit(this);
    }

    public void readLocalCommit_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalCommit(this);
    }

    public void writeLocalRollback_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalRollback(this);
    }

    public void readLocalRollback_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalRollback(this);
    }

    protected void markClosed_() {
    }

    protected boolean isGlobalPending_() {
        return false;
    }

    protected boolean doCloseStatementsOnClose_() {
        return true;
    }

    protected boolean allowCloseInUOW_() {
        return false;
    }

    protected boolean allowLocalCommitRollback_() throws SqlException {
        return this.xaState_ == 0;
    }

    public void setInputStream(InputStream inputStream) {
        this.netAgent_.setInputStream(inputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.netAgent_.setOutputStream(outputStream);
    }

    public InputStream getInputStream() {
        return this.netAgent_.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.netAgent_.getOutputStream();
    }

    public void writeTransactionStart(Statement statement) throws SqlException {
    }

    public void readTransactionStart() throws SqlException {
        super.readTransactionStart();
    }

    public void setIndoubtTransactions(Hashtable hashtable) {
    }

    protected void setReadOnlyTransactionFlag(boolean bl) {
        this.readOnlyTransaction_ = bl;
    }

    public SectionManager newSectionManager(String string, Agent agent, String string2) {
        return new SectionManager(string, agent, string2);
    }

    protected int getSocketAndInputOutputStreams(String string, int n) {
        try {
            this.netAgent_.socket_ = (Socket)AccessController.doPrivileged(new OpenSocketAction(string, n));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (this.netAgent_.loggingEnabled()) {
                this.netAgent_.logWriter_.tracepoint("[net]", 101, "Client Re-route: " + exception.getClass().getName() + " : " + exception.getMessage());
            }
            return -1;
        }
        try {
            this.netAgent_.rawSocketOutputStream_ = this.netAgent_.socket_.getOutputStream();
            this.netAgent_.rawSocketInputStream_ = this.netAgent_.socket_.getInputStream();
        }
        catch (IOException iOException) {
            if (this.netAgent_.loggingEnabled()) {
                this.netAgent_.logWriter_.tracepoint("[net]", 103, "Client Re-route: java.io.IOException " + iOException.getMessage());
            }
            try {
                this.netAgent_.socket_.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return -1;
        }
        return 0;
    }

    protected int checkAlternateServerHasEqualOrHigherProductLevel(ProductLevel productLevel, int n) {
        boolean bl;
        if (productLevel == null && n == 0) {
            return 0;
        }
        ProductLevel productLevel2 = this.netAgent_.netConnection_.databaseMetaData_.productLevel_;
        boolean bl2 = bl = productLevel2.greaterThanOrEqualTo(productLevel.versionLevel_, productLevel.releaseLevel_, productLevel.modificationLevel_);
        if (!bl && this.netAgent_.loggingEnabled()) {
            this.netAgent_.logWriter_.tracepoint("[net]", 99, "Client Re-route failed because the alternate server is on a lower product level than the origianl server.");
        }
        return bl ? 0 : -1;
    }

    public boolean willAutoCommitGenerateFlow() {
        if (!this.autoCommit_) {
            return false;
        }
        if (!this.isXAConnection_) {
            return true;
        }
        boolean bl = false;
        int n = this.getXAState();
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    public int getSecurityMechanism() {
        return this.securityMechanism_;
    }

    public EncryptionManager getEncryptionManager() {
        return this.encryptionManager_;
    }

    public byte[] getTargetPublicKey() {
        return this.targetPublicKey_;
    }

    public String getProductID() {
        return this.targetSrvclsnm_;
    }

    public void doResetNow() throws SqlException {
        if (!this.resetConnectionAtFirstSql_) {
            return;
        }
        this.agent_.beginWriteChainOutsideUOW();
        this.agent_.flowOutsideUOW();
        this.agent_.endReadChain();
    }
}

