/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.util;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class StandaloneWebappClassLoader
extends URLClassLoader {
    public static String FS = File.separator;

    public StandaloneWebappClassLoader(String webappDir, String jarsDir) throws Exception {
        super(StandaloneWebappClassLoader.buildURLsArray(webappDir, jarsDir));
    }

    public StandaloneWebappClassLoader(String webappDir, String jarsDir, ClassLoader cl) throws Exception {
        super(StandaloneWebappClassLoader.buildURLsArray(webappDir, jarsDir), cl);
    }

    private static URL[] buildURLsArray(String webappDir, String jarsDir) throws Exception {
        ArrayList<URL> urlList = new ArrayList<URL>();
        String libPath = webappDir + FS + "WEB-INF" + FS + "lib";
        StandaloneWebappClassLoader.addURLs(libPath, urlList);
        String classesPath = webappDir + FS + "WEB-INF" + FS + "classes" + FS;
        urlList.add(new URL("file://" + classesPath));
        StandaloneWebappClassLoader.addURLs(jarsDir, urlList);
        return urlList.toArray(new URL[urlList.size()]);
    }

    private static void addURLs(String dirPath, List urlList) throws Exception {
        File libDir = new File(dirPath);
        String[] libJarNames = libDir.list(new FilenameFilter(){

            public boolean accept(File dir, String pathname) {
                return pathname.endsWith(".jar");
            }
        });
        for (int i = 0; i < libJarNames.length; ++i) {
            String url = "file://" + dirPath + FS + libJarNames[i];
            urlList.add(new URL(url));
        }
    }
}

