/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.util;

import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailUtil {
    private static Log mLogger = LogFactory.getFactory().getInstance(MailUtil.class);

    public static void sendMessage(Session session, String from, String[] to, String[] cc, String[] bcc, String subject, String content, String mimeType) throws MessagingException {
        InternetAddress[] copyTo;
        int i;
        MimeMessage message = new MimeMessage(session);
        if (!StringUtils.isEmpty((String)from)) {
            InternetAddress sentFrom = new InternetAddress(from);
            message.setFrom((Address)sentFrom);
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("e-mail from: " + sentFrom));
            }
        }
        if (to != null) {
            InternetAddress[] sendTo = new InternetAddress[to.length];
            for (i = 0; i < to.length; ++i) {
                sendTo[i] = new InternetAddress(to[i]);
                if (!mLogger.isDebugEnabled()) continue;
                mLogger.debug((Object)("sending e-mail to: " + to[i]));
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])sendTo);
        }
        if (cc != null) {
            copyTo = new InternetAddress[cc.length];
            for (i = 0; i < cc.length; ++i) {
                copyTo[i] = new InternetAddress(cc[i]);
                if (!mLogger.isDebugEnabled()) continue;
                mLogger.debug((Object)("copying e-mail to: " + cc[i]));
            }
            message.setRecipients(Message.RecipientType.CC, (Address[])copyTo);
        }
        if (bcc != null) {
            copyTo = new InternetAddress[bcc.length];
            for (i = 0; i < bcc.length; ++i) {
                copyTo[i] = new InternetAddress(bcc[i]);
                if (!mLogger.isDebugEnabled()) continue;
                mLogger.debug((Object)("blind copying e-mail to: " + bcc[i]));
            }
            message.setRecipients(Message.RecipientType.BCC, (Address[])copyTo);
        }
        message.setSubject(subject == null ? "(no subject)" : subject);
        message.setContent((Object)content, mimeType);
        message.setSentDate(new Date());
        Address[] remainingAddresses = message.getAllRecipients();
        int nAddresses = remainingAddresses.length;
        boolean bFailedToSome = false;
        SendFailedException sendex = new SendFailedException("Unable to send message to some recipients");
        do {
            nAddresses = remainingAddresses.length;
            try {
                Transport.send((Message)message, (Address[])remainingAddresses);
            }
            catch (SendFailedException ex) {
                bFailedToSome = true;
                sendex.setNextException((Exception)((Object)ex));
                remainingAddresses = ex.getValidUnsentAddresses();
            }
        } while (remainingAddresses != null && remainingAddresses.length > 0 && remainingAddresses.length != nAddresses);
        if (bFailedToSome) {
            throw sendex;
        }
    }

    public static void sendTextMessage(Session session, String from, String[] to, String[] cc, String[] bcc, String subject, String content) throws MessagingException {
        MailUtil.sendMessage(session, from, to, cc, bcc, subject, content, "text/plain; charset=utf-8");
    }

    public static void sendTextMessage(Session session, String from, String to, String[] cc, String[] bcc, String subject, String content) throws MessagingException {
        String[] recipient = null;
        if (to != null) {
            recipient = new String[]{to};
        }
        MailUtil.sendMessage(session, from, recipient, cc, bcc, subject, content, "text/plain; charset=utf-8");
    }

    public static void sendTextMessage(Session session, String from, String to, String cc, String bcc, String subject, String content) throws MessagingException {
        String[] recipient = null;
        String[] copy = null;
        String[] bcopy = null;
        if (to != null) {
            recipient = new String[]{to};
        }
        if (cc != null) {
            copy = new String[]{cc};
        }
        if (bcc != null) {
            bcopy = new String[]{bcc};
        }
        MailUtil.sendMessage(session, from, recipient, copy, bcopy, subject, content, "text/plain; charset=utf-8");
    }

    public static void sendHTMLMessage(Session session, String from, String[] to, String[] cc, String[] bcc, String subject, String content) throws MessagingException {
        MailUtil.sendMessage(session, from, to, cc, bcc, subject, content, "text/html; charset=utf-8");
    }

    public static void sendHTMLMessage(Session session, String from, String to, String cc, String bcc, String subject, String content) throws MessagingException {
        String[] recipient = null;
        String[] copy = null;
        String[] bcopy = null;
        if (to != null) {
            recipient = new String[]{to};
        }
        if (cc != null) {
            copy = new String[]{cc};
        }
        if (bcc != null) {
            bcopy = new String[]{bcc};
        }
        MailUtil.sendMessage(session, from, recipient, copy, bcopy, subject, content, "text/html; charset=utf-8");
    }

    public static void sendHTMLMessage(Session session, String from, String to, String[] cc, String[] bcc, String subject, String content) throws MessagingException {
        String[] recipient = null;
        if (to != null) {
            recipient = new String[]{to};
        }
        MailUtil.sendMessage(session, from, recipient, cc, bcc, subject, content, "text/html; charset=utf-8");
    }
}

