/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.config;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.business.PlanetFactory;
import org.apache.roller.planet.business.PropertiesManager;
import org.apache.roller.planet.config.PlanetConfig;
import org.apache.roller.planet.config.runtime.RuntimeConfigDefs;
import org.apache.roller.planet.config.runtime.RuntimeConfigDefsParser;

public class PlanetRuntimeConfig {
    private static Log log = LogFactory.getLog(PlanetRuntimeConfig.class);
    private static String runtime_config = "/org/apache/roller/planet/config/planetRuntimeConfigDefs.xml";
    private static RuntimeConfigDefs configDefs = null;
    private static String relativeContextURL = null;
    private static String absoluteContextURL = null;

    private PlanetRuntimeConfig() {
    }

    public static String getProperty(String name) {
        String value = null;
        try {
            PropertiesManager pmgr = PlanetFactory.getPlanet().getPropertiesManager();
            value = pmgr.getProperty(name).getValue();
        }
        catch (Exception e) {
            log.warn((Object)("Trouble accessing property: " + name), (Throwable)e);
        }
        log.debug((Object)("fetched property [" + name + "=" + value + "]"));
        return value;
    }

    public static boolean getBooleanProperty(String name) {
        String value = PlanetRuntimeConfig.getProperty(name);
        if (value == null) {
            return false;
        }
        return new Boolean(value);
    }

    public static int getIntProperty(String name) {
        String value = PlanetRuntimeConfig.getProperty(name);
        if (value == null) {
            return -1;
        }
        int intval = -1;
        try {
            intval = Integer.parseInt(value);
        }
        catch (Exception e) {
            log.warn((Object)("Trouble converting to int: " + name), (Throwable)e);
        }
        return intval;
    }

    public static RuntimeConfigDefs getRuntimeConfigDefs() {
        if (configDefs == null) {
            try {
                InputStream is = PlanetRuntimeConfig.class.getResourceAsStream(runtime_config);
                RuntimeConfigDefsParser parser = new RuntimeConfigDefsParser();
                configDefs = parser.unmarshall(is);
            }
            catch (Exception e) {
                log.error((Object)"Error parsing runtime config defs", (Throwable)e);
            }
        }
        return configDefs;
    }

    public static String getRuntimeConfigDefsAsString() {
        log.debug((Object)"Trying to load runtime config defs file");
        try {
            InputStreamReader reader = new InputStreamReader(PlanetConfig.class.getResourceAsStream(runtime_config));
            StringWriter configString = new StringWriter();
            char[] buf = new char[8196];
            int length = 0;
            while ((length = reader.read(buf)) > 0) {
                configString.write(buf, 0, length);
            }
            reader.close();
            return configString.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error loading runtime config defs file", (Throwable)e);
            return "";
        }
    }
}

