/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.util.PropertyExpander;

public class PlanetConfig {
    private static String default_config = "/org/apache/roller/planet/config/planet.properties";
    private static String custom_config = "/planet-custom.properties";
    private static String custom_jvm_param = "planet.custom.config";
    private static File custom_config_file = null;
    private static Properties mConfig;
    private static Log log;

    private PlanetConfig() {
    }

    public static String getProperty(String key) {
        log.debug((Object)("Fetching property [" + key + "=" + mConfig.getProperty(key) + "]"));
        return mConfig.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        log.debug((Object)("Fetching property [" + key + "=" + mConfig.getProperty(key) + ",defaultValue=" + defaultValue + "]"));
        String value = mConfig.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static boolean getBooleanProperty(String name) {
        return PlanetConfig.getBooleanProperty(name, false);
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = PlanetConfig.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return new Boolean(value);
    }

    public static int getIntProperty(String name) {
        return PlanetConfig.getIntProperty(name, 0);
    }

    public static int getIntProperty(String name, int defaultValue) {
        String value = PlanetConfig.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return new Integer(value);
    }

    public static Enumeration keys() {
        return mConfig.keys();
    }

    public static void setPlanetCachePath(String path) {
        mConfig.setProperty("planet.aggregator.cache.dir", path);
    }

    static {
        log = LogFactory.getLog(PlanetConfig.class);
        mConfig = new Properties();
        try {
            Class<?> config_class = Class.forName("org.apache.roller.planet.config.PlanetConfig");
            InputStream is = config_class.getResourceAsStream(default_config);
            mConfig.load(is);
            log.info((Object)"successfully loaded default properties.");
            is = config_class.getResourceAsStream(custom_config);
            if (is != null) {
                mConfig.load(is);
                log.info((Object)"successfully loaded custom properties file from classpath");
            } else {
                log.info((Object)"no custom properties file found in classpath");
            }
            String env_file = System.getProperty(custom_jvm_param);
            if (env_file != null && env_file.length() > 0) {
                custom_config_file = new File(env_file);
                if (custom_config_file != null && custom_config_file.exists()) {
                    is = new FileInputStream(custom_config_file);
                    mConfig.load(is);
                    log.info((Object)("successfully loaded custom properties from " + custom_config_file.getAbsolutePath()));
                } else {
                    log.warn((Object)("failed to load custom properties from " + custom_config_file.getAbsolutePath()));
                }
            } else {
                log.info((Object)"no custom properties file specified via jvm option");
            }
            String expandedPropertiesDef = (String)mConfig.get("config.expandedProperties");
            if (expandedPropertiesDef != null) {
                String[] expandedProperties = expandedPropertiesDef.split(",");
                for (int i = 0; i < expandedProperties.length; ++i) {
                    String propName = expandedProperties[i].trim();
                    String initialValue = (String)mConfig.get(propName);
                    if (initialValue == null) continue;
                    String expandedValue = PropertyExpander.expandSystemProperties((String)initialValue);
                    mConfig.put(propName, expandedValue);
                    if (!log.isDebugEnabled()) continue;
                    log.info((Object)("Expanded value of " + propName + " from '" + initialValue + "' to '" + expandedValue + "'"));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"PlanetConfig looks like this ...");
                String key = null;
                Enumeration<Object> keys = mConfig.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    log.debug((Object)(key + "=" + mConfig.getProperty(key)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

