/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business.hibernate;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.PlanetException;
import org.apache.roller.planet.business.AbstractManagerImpl;
import org.apache.roller.planet.business.InitializationException;
import org.apache.roller.planet.business.PropertiesManager;
import org.apache.roller.planet.business.hibernate.HibernatePersistenceStrategy;
import org.apache.roller.planet.config.PlanetRuntimeConfig;
import org.apache.roller.planet.config.runtime.ConfigDef;
import org.apache.roller.planet.config.runtime.DisplayGroup;
import org.apache.roller.planet.config.runtime.PropertyDef;
import org.apache.roller.planet.config.runtime.RuntimeConfigDefs;
import org.apache.roller.planet.pojos.RuntimeConfigProperty;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;

@Singleton
public class HibernatePropertiesManagerImpl
extends AbstractManagerImpl
implements PropertiesManager {
    private static Log log = LogFactory.getLog(HibernatePropertiesManagerImpl.class);
    private final HibernatePersistenceStrategy strategy;

    @Inject
    protected HibernatePropertiesManagerImpl(HibernatePersistenceStrategy strat) {
        log.debug((Object)"Instantiating Hibernate Properties Manager");
        this.strategy = strat;
    }

    public RuntimeConfigProperty getProperty(String name) throws PlanetException {
        try {
            return (RuntimeConfigProperty)this.strategy.load(name, RuntimeConfigProperty.class);
        }
        catch (HibernateException e) {
            throw new PlanetException(e);
        }
    }

    public Map getProperties() throws PlanetException {
        HashMap<String, RuntimeConfigProperty> props = new HashMap<String, RuntimeConfigProperty>();
        try {
            Session session = this.strategy.getSession();
            Criteria criteria = session.createCriteria(RuntimeConfigProperty.class);
            List list = criteria.list();
            RuntimeConfigProperty prop2 = null;
            for (RuntimeConfigProperty prop2 : list) {
                props.put(prop2.getName(), prop2);
            }
        }
        catch (HibernateException e) {
            throw new PlanetException(e);
        }
        return props;
    }

    public void saveProperty(RuntimeConfigProperty property) throws PlanetException {
        this.strategy.store(property);
    }

    public void saveProperties(Map properties) throws PlanetException {
        Iterator props = properties.values().iterator();
        while (props.hasNext()) {
            this.strategy.store((RuntimeConfigProperty)props.next());
        }
    }

    public void initialize() throws InitializationException {
        Map props = null;
        try {
            props = this.getProperties();
            props = this.initializeMissingProps(props);
            this.saveProperties(props);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialize runtime configuration properties.Please check that the database has been upgraded!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Map initializeMissingProps(Map props) {
        RuntimeConfigDefs runtimeConfigDefs;
        if (props == null) {
            props = new HashMap<String, RuntimeConfigProperty>();
        }
        if ((runtimeConfigDefs = PlanetRuntimeConfig.getRuntimeConfigDefs()) == null) {
            return props;
        }
        ConfigDef configDef2 = null;
        DisplayGroup dGroup2 = null;
        PropertyDef propDef2 = null;
        for (ConfigDef configDef2 : runtimeConfigDefs.getConfigDefs()) {
            for (DisplayGroup dGroup2 : configDef2.getDisplayGroups()) {
                for (PropertyDef propDef2 : dGroup2.getPropertyDefs()) {
                    if (props.containsKey(propDef2.getName())) continue;
                    RuntimeConfigProperty newprop = new RuntimeConfigProperty(propDef2.getName(), propDef2.getDefaultValue());
                    props.put(propDef2.getName(), newprop);
                    log.info((Object)("Found uninitialized property " + propDef2.getName() + " ... setting value to [" + propDef2.getDefaultValue() + "]"));
                }
            }
        }
        return props;
    }
}

