/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.dispatcher;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.StrutsException;
import org.apache.struts2.StrutsStatics;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.portlet.PortletActionConstants;
import org.apache.struts2.portlet.PortletApplicationMap;
import org.apache.struts2.portlet.PortletRequestMap;
import org.apache.struts2.portlet.PortletSessionMap;
import org.apache.struts2.portlet.context.ServletContextHolderListener;
import org.apache.struts2.portlet.util.HttpServletRequestMock;
import org.apache.struts2.util.AttributeMap;

public class Jsr168Dispatcher
extends GenericPortlet
implements StrutsStatics,
PortletActionConstants {
    private static final Log LOG = LogFactory.getLog(Jsr168Dispatcher.class);
    private ActionProxyFactory factory = null;
    private Map<PortletMode, String> modeMap = new HashMap<PortletMode, String>(3);
    private Map<PortletMode, ActionMapping> actionMap = new HashMap<PortletMode, ActionMapping>(3);
    private String portletNamespace = null;
    private Dispatcher dispatcherUtils;
    private ActionMapper actionMapper;

    public void init(PortletConfig cfg) throws PortletException {
        super.init(cfg);
        LOG.debug((Object)("Initializing portlet " + this.getPortletName()));
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration e = cfg.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = cfg.getInitParameter(name);
            params.put(name, value);
        }
        Dispatcher.setPortletSupportActive(true);
        this.dispatcherUtils = new Dispatcher(ServletContextHolderListener.getServletContext(), params);
        this.dispatcherUtils.init();
        if (this.factory == null) {
            this.factory = (ActionProxyFactory)this.dispatcherUtils.getConfigurationManager().getConfiguration().getContainer().getInstance(ActionProxyFactory.class);
        }
        this.portletNamespace = cfg.getInitParameter("portletNamespace");
        LOG.debug((Object)("PortletNamespace: " + this.portletNamespace));
        this.parseModeConfig(cfg, PortletMode.VIEW, "viewNamespace", "defaultViewAction");
        this.parseModeConfig(cfg, PortletMode.EDIT, "editNamespace", "defaultEditAction");
        this.parseModeConfig(cfg, PortletMode.HELP, "helpNamespace", "defaultHelpAction");
        this.parseModeConfig(cfg, new PortletMode("config"), "configNamespace", "defaultConfigAction");
        this.parseModeConfig(cfg, new PortletMode("about"), "aboutNamespace", "defaultAboutAction");
        this.parseModeConfig(cfg, new PortletMode("print"), "printNamespace", "defaultPrintAction");
        this.parseModeConfig(cfg, new PortletMode("preview"), "previewNamespace", "defaultPreviewAction");
        this.parseModeConfig(cfg, new PortletMode("edit_defaults"), "editDefaultsNamespace", "defaultEditDefaultsAction");
        if (!TextUtils.stringSet((String)this.portletNamespace)) {
            this.portletNamespace = "";
        }
        LocalizedTextUtil.addDefaultResourceBundle((String)"org/apache/struts2/struts-messages");
        Container container = this.dispatcherUtils.getContainer();
        if ("true".equalsIgnoreCase((String)container.getInstance(String.class, "struts.configuration.xml.reload"))) {
            FileManager.setReloadingConfigs((boolean)true);
        }
        this.actionMapper = (ActionMapper)container.getInstance(ActionMapper.class);
    }

    private void parseModeConfig(PortletConfig portletConfig, PortletMode portletMode, String nameSpaceParam, String defaultActionParam) {
        String namespace = portletConfig.getInitParameter(nameSpaceParam);
        if (!TextUtils.stringSet((String)namespace)) {
            namespace = "";
        }
        this.modeMap.put(portletMode, namespace);
        String defaultAction = portletConfig.getInitParameter(defaultActionParam);
        if (!TextUtils.stringSet((String)defaultAction)) {
            defaultAction = "default";
        }
        StringBuffer fullPath = new StringBuffer();
        if (TextUtils.stringSet((String)this.portletNamespace)) {
            fullPath.append(this.portletNamespace);
        }
        if (TextUtils.stringSet((String)namespace)) {
            fullPath.append(namespace).append("/");
        } else {
            fullPath.append("/");
        }
        fullPath.append(defaultAction);
        ActionMapping mapping = new ActionMapping();
        mapping.setName(this.getActionName(fullPath.toString()));
        mapping.setNamespace(this.getNamespace(fullPath.toString()));
        this.actionMap.put(portletMode, mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        LOG.debug((Object)"Entering processAction");
        this.resetActionContext();
        try {
            this.serviceAction((PortletRequest)request, (PortletResponse)response, this.getActionMapping((PortletRequest)request), this.getRequestMap((PortletRequest)request), this.getParameterMap((PortletRequest)request), this.getSessionMap((PortletRequest)request), this.getApplicationMap(), this.portletNamespace, EVENT_PHASE);
            LOG.debug((Object)"Leaving processAction");
        }
        finally {
            ActionContext.setContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        LOG.debug((Object)"Entering render");
        this.resetActionContext();
        response.setTitle(this.getTitle(request));
        try {
            this.serviceAction((PortletRequest)request, (PortletResponse)response, this.getActionMapping((PortletRequest)request), this.getRequestMap((PortletRequest)request), this.getParameterMap((PortletRequest)request), this.getSessionMap((PortletRequest)request), this.getApplicationMap(), this.portletNamespace, RENDER_PHASE);
            LOG.debug((Object)"Leaving render");
        }
        finally {
            this.resetActionContext();
        }
    }

    private void resetActionContext() {
        ActionContext.setContext(null);
    }

    public HashMap createContextMap(Map requestMap, Map parameterMap, Map sessionMap, Map applicationMap, PortletRequest request, PortletResponse response, PortletConfig portletConfig, Integer phase) {
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork2.ActionContext.parameters", parameterMap);
        extraContext.put("com.opensymphony.xwork2.ActionContext.session", sessionMap);
        extraContext.put("com.opensymphony.xwork2.ActionContext.application", applicationMap);
        String defaultLocale = (String)this.dispatcherUtils.getContainer().getInstance(String.class, "struts.locale");
        Locale locale = null;
        locale = defaultLocale != null ? LocalizedTextUtil.localeFromString((String)defaultLocale, (Locale)request.getLocale()) : request.getLocale();
        extraContext.put("com.opensymphony.xwork2.ActionContext.locale", locale);
        extraContext.put("struts.portlet.context", this.getPortletContext());
        extraContext.put("struts.portlet.request", request);
        extraContext.put("struts.portlet.response", response);
        extraContext.put("struts.portlet.config", portletConfig);
        extraContext.put("struts.portlet.portletNamespace", this.portletNamespace);
        extraContext.put("struts.portlet.defaultActionForMode", this.actionMap.get(request.getPortletMode()));
        extraContext.put("request", requestMap);
        extraContext.put("session", sessionMap);
        extraContext.put("application", applicationMap);
        extraContext.put("parameters", parameterMap);
        extraContext.put("struts.portlet.modeNamespaceMap", this.modeMap);
        extraContext.put("struts.portlet.phase", phase);
        AttributeMap attrMap = new AttributeMap(extraContext);
        extraContext.put("attr", attrMap);
        return extraContext;
    }

    public void serviceAction(PortletRequest request, PortletResponse response, ActionMapping mapping, Map requestMap, Map parameterMap, Map sessionMap, Map applicationMap, String portletNamespace, Integer phase) throws PortletException {
        LOG.debug((Object)"serviceAction");
        HashMap extraContext = this.createContextMap(requestMap, parameterMap, sessionMap, applicationMap, request, response, this.getPortletConfig(), phase);
        String actionName = mapping.getName();
        String namespace = mapping.getNamespace();
        Dispatcher.setInstance(this.dispatcherUtils);
        try {
            ActionProxy action;
            LOG.debug((Object)("Creating action proxy for name = " + actionName + ", namespace = " + namespace));
            ActionProxy proxy = this.factory.createActionProxy(namespace, actionName, (Map)extraContext);
            proxy.setMethod(mapping.getMethod());
            request.setAttribute("struts.valueStack", (Object)proxy.getInvocation().getStack());
            if (PortletActionConstants.RENDER_PHASE.equals(phase) && TextUtils.stringSet((String)request.getParameter("struts.portlet.eventAction")) && (action = (ActionProxy)request.getPortletSession().getAttribute("struts.portlet.eventAction")) != null) {
                ValueStack stack = proxy.getInvocation().getStack();
                Object top = stack.pop();
                stack.push(action.getInvocation().getAction());
                stack.push(top);
            }
            proxy.execute();
            if (PortletActionConstants.EVENT_PHASE.equals(phase)) {
                ActionResponse actionResp = (ActionResponse)response;
                request.getPortletSession().setAttribute("struts.portlet.eventAction", (Object)proxy);
                actionResp.setRenderParameter("struts.portlet.eventAction", "true");
            }
        }
        catch (ConfigurationException e) {
            LOG.error((Object)"Could not find action", (Throwable)e);
            throw new PortletException("Could not find action " + actionName, (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not execute action", (Throwable)e);
            throw new PortletException("Error executing action " + actionName, (Throwable)e);
        }
        finally {
            Dispatcher.setInstance(null);
        }
    }

    protected Map getApplicationMap() {
        return new PortletApplicationMap(this.getPortletContext());
    }

    protected ActionMapping getActionMapping(PortletRequest request) {
        ActionMapping mapping = null;
        String actionPath = null;
        if (this.resetAction(request)) {
            mapping = this.actionMap.get(request.getPortletMode());
        } else {
            actionPath = request.getParameter("struts.portlet.action");
            if (!TextUtils.stringSet((String)actionPath)) {
                mapping = this.actionMap.get(request.getPortletMode());
            } else {
                HttpServletRequestMock httpRequest = new HttpServletRequestMock().setServletPath(actionPath + ".action").setParameterMap(request.getParameterMap());
                mapping = this.actionMapper.getMapping(httpRequest, this.dispatcherUtils.getConfigurationManager());
            }
        }
        if (mapping == null) {
            throw new StrutsException("Unable to locate action mapping for request, probably due to an invalid action path: " + actionPath);
        }
        return mapping;
    }

    String getNamespace(String actionPath) {
        int idx = actionPath.lastIndexOf(47);
        String namespace = "";
        if (idx >= 0) {
            namespace = actionPath.substring(0, idx);
        }
        return namespace;
    }

    String getActionName(String actionPath) {
        int idx = actionPath.lastIndexOf(47);
        String action = actionPath;
        if (idx >= 0) {
            action = actionPath.substring(idx + 1);
        }
        return action;
    }

    protected Map getParameterMap(PortletRequest request) throws IOException {
        return new HashMap(request.getParameterMap());
    }

    protected Map getRequestMap(PortletRequest request) {
        return new PortletRequestMap(request);
    }

    protected Map getSessionMap(PortletRequest request) {
        return new PortletSessionMap(request);
    }

    protected void setActionProxyFactory(ActionProxyFactory factory) {
        this.factory = factory;
    }

    private boolean resetAction(PortletRequest request) {
        boolean reset = false;
        Map paramMap = request.getParameterMap();
        String[] modeParam = (String[])paramMap.get("struts.portlet.mode");
        if (modeParam != null && modeParam.length == 1) {
            String originatingMode = modeParam[0];
            String currentMode = request.getPortletMode().toString();
            if (!currentMode.equals(originatingMode)) {
                reset = true;
            }
        }
        return reset;
    }

    public void destroy() {
        if (this.dispatcherUtils == null) {
            LOG.warn((Object)"something is seriously wrong, DispatcherUtil is not initialized (null) ");
        } else {
            this.dispatcherUtils.cleanup();
        }
    }

    public void setActionMapper(ActionMapper actionMapper) {
        this.actionMapper = actionMapper;
    }
}

