/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components.template;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ValueStack;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.template.BaseTemplateEngine;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.views.freemarker.FreemarkerManager;

public class FreemarkerTemplateEngine
extends BaseTemplateEngine {
    static Class bodyContent = null;
    private FreemarkerManager freemarkerManager;
    private static final Log LOG;

    @Inject
    public void setFreemarkerManager(FreemarkerManager mgr) {
        this.freemarkerManager = mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        ActionInvocation ai;
        ValueStack stack = templateContext.getStack();
        Map context = stack.getContext();
        ServletContext servletContext = (ServletContext)context.get("com.opensymphony.xwork2.dispatcher.ServletContext");
        HttpServletRequest req = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse res = (HttpServletResponse)context.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        Configuration config = this.freemarkerManager.getConfiguration(servletContext);
        List templates = templateContext.getTemplate().getPossibleTemplates(this);
        freemarker.template.Template template = null;
        String templateName = null;
        IOException exception = null;
        for (Template t : templates) {
            templateName = this.getFinalTemplateName(t);
            try {
                template = config.getTemplate(templateName);
                break;
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (template == null) {
            LOG.error((Object)("Could not load template " + templateContext.getTemplate()));
            if (exception != null) {
                throw exception;
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rendering template " + templateName));
        }
        Object action = (ai = ActionContext.getContext().getActionInvocation()) == null ? null : ai.getAction();
        SimpleHash model = this.freemarkerManager.buildTemplateModel(stack, action, servletContext, req, res, config.getObjectWrapper());
        model.put("tag", (Object)templateContext.getTag());
        model.put("themeProperties", (Object)this.getThemeProps(templateContext.getTemplate()));
        Writer writer = templateContext.getWriter();
        if (bodyContent != null && bodyContent.isAssignableFrom(writer.getClass())) {
            final Writer wrapped = writer;
            writer = new Writer(){

                public void write(char[] cbuf, int off, int len) throws IOException {
                    wrapped.write(cbuf, off, len);
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                    wrapped.close();
                }
            };
        }
        try {
            stack.push((Object)templateContext.getTag());
            template.process((Object)model, writer);
        }
        finally {
            stack.pop();
        }
    }

    protected String getSuffix() {
        return "ftl";
    }

    static {
        try {
            bodyContent = ClassLoaderUtil.loadClass((String)"javax.servlet.jsp.tagext.BodyContent", FreemarkerTemplateEngine.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LOG = LogFactory.getLog(FreemarkerTemplateEngine.class);
    }
}

