/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.RuntimeConfiguration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MethodConfigurationProvider
implements ConfigurationProvider {
    private Configuration configuration;
    boolean reload;
    ObjectFactory factory;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void destroy() {
    }

    public void init(Configuration configuration) throws ConfigurationException {
        this.setConfiguration(configuration);
        configuration.rebuildRuntimeConfiguration();
    }

    public void register(ContainerBuilder containerBuilder, LocatableProperties locatableProperties) throws ConfigurationException {
    }

    public void loadPackages() throws ConfigurationException {
        Set namespaces = Collections.EMPTY_SET;
        RuntimeConfiguration rc = this.configuration.getRuntimeConfiguration();
        Map allActionConfigs = rc.getActionConfigs();
        if (allActionConfigs != null) {
            namespaces = allActionConfigs.keySet();
        }
        if (namespaces.size() == 0) {
            throw new ConfigurationException("MethodConfigurationProvider.loadPackages: namespaces.size == 0");
        }
        boolean added = false;
        for (Object namespace : namespaces) {
            Map actions = (Map)allActionConfigs.get(namespace);
            Set actionNames = actions.keySet();
            for (Object actionName : actionNames) {
                ActionConfig actionConfig = (ActionConfig)actions.get(actionName);
                added |= this.addDynamicMethods(actions, (String)actionName, actionConfig);
            }
        }
        this.reload = added;
    }

    public boolean needsReload() {
        return this.reload;
    }

    public void setObjectFactory(ObjectFactory factory) {
        this.factory = factory;
    }

    private ObjectFactory getObjectFactory() throws ConfigurationException {
        if (this.factory == null) {
            this.factory = ObjectFactory.getObjectFactory();
            if (this.factory == null) {
                throw new ConfigurationException("MethodConfigurationProvider.getObjectFactory: ObjectFactory==null");
            }
        }
        return this.factory;
    }

    private boolean upperAt(int pos, String string) {
        int len = string.length();
        if (len < pos) {
            return false;
        }
        String ch = string.substring(pos, pos + 1);
        return ch.equals(ch.toUpperCase());
    }

    protected boolean addDynamicMethods(Map actions, String actionName, ActionConfig actionConfig) throws ConfigurationException {
        Method[] methods;
        Class actionClass;
        boolean hasMethod;
        String configMethod = actionConfig.getMethodName();
        boolean bl = hasMethod = configMethod != null && configMethod.length() > 0;
        if (hasMethod) {
            return false;
        }
        String className = actionConfig.getClassName();
        HashSet<String> actionMethods = new HashSet<String>();
        ObjectFactory factory = this.getObjectFactory();
        try {
            actionClass = factory.getClassInstance(className);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
        for (Method method : methods = actionClass.getMethods()) {
            boolean qualifies;
            String returnString = method.getReturnType().getName();
            boolean isString = "java.lang.String".equals(returnString);
            if (!isString) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean noParameters = parameterTypes.length == 0;
            String methodString = method.getName();
            boolean notGetMethod = !methodString.startsWith("get") || !this.upperAt(3, methodString);
            boolean notIsMethod = !methodString.startsWith("is") || !this.upperAt(2, methodString);
            boolean notToString = !"toString".equals(methodString);
            boolean notExecute = !"execute".equals(methodString);
            boolean bl2 = qualifies = noParameters && notGetMethod && notIsMethod && notToString && notExecute;
            if (!qualifies) continue;
            actionMethods.add(methodString);
        }
        for (Object e : actionMethods) {
            String methodName = (String)e;
            StringBuilder sb = new StringBuilder();
            sb.append(actionName);
            sb.append("!");
            sb.append(methodName);
            String newActionName = sb.toString();
            boolean haveAction = actions.containsKey(newActionName);
            if (haveAction) continue;
            ActionConfig newActionConfig = new ActionConfig(newActionName, actionConfig.getClassName(), actionConfig.getParams(), actionConfig.getResults(), actionConfig.getInterceptors(), actionConfig.getExceptionMappings());
            newActionConfig.setMethodName(methodName);
            String packageName = actionConfig.getPackageName();
            newActionConfig.setPackageName(packageName);
            PackageConfig packageConfig = this.configuration.getPackageConfig(packageName);
            packageConfig.addActionConfig(newActionName, actionConfig);
        }
        return actionMethods.size() > 0;
    }
}

