/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components.template;

import com.opensymphony.xwork2.util.ValueStack;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.components.Include;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.components.template.BaseTemplateEngine;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateRenderingContext;

public class JspTemplateEngine
extends BaseTemplateEngine {
    private static final Log LOG = LogFactory.getLog(JspTemplateEngine.class);

    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        Template template = templateContext.getTemplate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Trying to render template " + template + ", repeating through parents until we succeed"));
        }
        UIBean tag = templateContext.getTag();
        ValueStack stack = templateContext.getStack();
        stack.push((Object)tag);
        PageContext pageContext = (PageContext)stack.getContext().get("com.opensymphony.xwork2.dispatcher.PageContext");
        List templates = template.getPossibleTemplates(this);
        Exception exception = null;
        boolean success = false;
        for (Template t : templates) {
            try {
                Include.include(this.getFinalTemplateName(t), (Writer)pageContext.getOut(), pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse());
                success = true;
                break;
            }
            catch (Exception e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (!success) {
            LOG.error((Object)("Could not render JSP template " + templateContext.getTemplate()));
            if (exception != null) {
                throw exception;
            }
            return;
        }
        stack.pop();
    }

    protected String getSuffix() {
        return "jsp";
    }
}

