/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid.state;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.discovery.tools.DiscoverClass;
import org.apache.commons.id.DecoderException;
import org.apache.commons.id.DigestUtils;
import org.apache.commons.id.Hex;
import org.apache.commons.id.uuid.Bytes;
import org.apache.commons.id.uuid.Constants;
import org.apache.commons.id.uuid.clock.Clock;
import org.apache.commons.id.uuid.clock.OverClockedException;
import org.apache.commons.id.uuid.state.State;

public final class StateHelper
implements Constants {
    public static final String UUID_CLOCK_IMPL_PROPERTY_KEY = Clock.class.getName();
    public static final String UUID_STATE_IMPL_PROPERTY_KEY = State.class.getName();
    public static final int NODE_ID_BYTE_LENGTH = 6;
    public static final short BYTES_IN_SHORT = 2;
    public static final short SHIFT_BY_BYTE = 8;
    public static final short HOSTNAME_MAX_CHAR_LEN = 255;
    private static final int MULTICAST_BIT_SET = 128;
    private static final short LONG_CHAR_LEN = 19;
    private static final int BUF_PAGE_SZ = 1024;
    protected static final String XML_DOC_START = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE uuidstate [\n   <!ELEMENT uuidstate (node*)>\n   <!ELEMENT node EMPTY>\n   <!ATTLIST node id ID #REQUIRED>\n   <!ATTLIST node clocksequence CDATA #IMPLIED>\n   <!ATTLIST node lasttimestamp CDATA #IMPLIED>\n]>\n<uuidstate synchInterval=\"";
    protected static final String XML_DOC_START_END = "\">";
    protected static final String XML_NODE_TAG_START = "\n\t<node id=\"";
    protected static final String XML_NODE_TAG_AFTER_ID = "\" clocksequence=\"";
    protected static final String XML_NODE_TAG_AFTER_CSEQ = "\" timestamp=\"";
    protected static final String XML_NODE_TAG_END = "\" />";
    protected static final String XML_DOC_END = "\n</uuidstate>";
    private static final short MAC_ADDRESS_TOKEN_COUNT = 6;
    private static final short MAC_ADDRESS_CHAR_LENGTH = 17;

    private StateHelper() {
    }

    public static byte[] randomNodeIdentifier() {
        byte[] seed = new byte[16];
        int bufSize = 2341;
        StringBuffer randInfo = new StringBuffer(bufSize);
        long time = 0L;
        try {
            time = StateHelper.getClockImpl().getUUIDTime();
        }
        catch (OverClockedException oce) {
            time = System.currentTimeMillis();
        }
        randInfo.append(time);
        try {
            InetAddress address = InetAddress.getLocalHost();
            randInfo.append(address.getHostName());
        }
        catch (UnknownHostException ukhe) {
            randInfo.append("Host Unknown");
        }
        randInfo.append(new Object().hashCode());
        Collection<Object> info = System.getProperties().values();
        Iterator<Object> it = info.iterator();
        while (it.hasNext()) {
            randInfo.append(it.next());
        }
        seed = DigestUtils.md5(randInfo.toString());
        byte[] raw = new byte[6];
        System.arraycopy(seed, 0, raw, 0, 6);
        raw[0] = (byte)(raw[0] | 0x80);
        return raw;
    }

    public static short newClockSequence() {
        Random random = new Random();
        byte[] bytes = new byte[2];
        random.nextBytes(bytes);
        return (short)(Bytes.toShort(bytes) & 0x3FFF);
    }

    public static Clock getClockImpl() {
        Clock c = null;
        try {
            DiscoverClass dc = new DiscoverClass();
            c = (Clock)dc.newInstance(Clock.class, "org.apache.commons.id.uuid.clock.SystemClockImpl");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return c;
    }

    public static State getStateImpl() {
        State s = null;
        try {
            DiscoverClass dc = new DiscoverClass();
            s = (State)dc.newInstance(State.class, "org.apache.commons.id.uuid.state.ReadOnlyResourceStateImpl");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    public static byte[] decodeMACAddress(String address) {
        StringBuffer buf = new StringBuffer(12);
        StringTokenizer tokens = new StringTokenizer(address, "-");
        if (tokens.countTokens() != 6) {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            buf.append(tokens.nextToken());
        }
        try {
            char[] c = buf.toString().toCharArray();
            return Hex.decodeHex(c);
        }
        catch (DecoderException de) {
            de.printStackTrace();
            return null;
        }
    }

    public static String encodeMACAddress(byte[] address) throws IOException {
        char[] chars = Hex.encodeHex(address);
        StringBuffer buf = new StringBuffer(17);
        for (int i = 0; i < chars.length; ++i) {
            buf.append(chars[i]);
            if (i == chars.length - 1 || i % 2 == 0) continue;
            buf.append("-");
        }
        return buf.toString().toUpperCase();
    }
}

