/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid.state;

import java.util.Arrays;
import org.apache.commons.id.uuid.clock.Clock;
import org.apache.commons.id.uuid.clock.OverClockedException;
import org.apache.commons.id.uuid.state.StateHelper;

public class Node {
    private byte[] id;
    private short clockSequence;
    private long lastTimestamp;
    private Clock clock;

    public Node(byte[] nodeId) {
        this.id = nodeId;
        this.clockSequence = StateHelper.newClockSequence();
        this.clock = StateHelper.getClockImpl();
    }

    public Node(byte[] nodeId, long lastTime, short clockSeq) {
        this.id = nodeId;
        this.lastTimestamp = lastTime;
        this.clockSequence = clockSeq;
        this.clock = StateHelper.getClockImpl();
    }

    public byte[] getNodeIdentifier() {
        return this.id;
    }

    public short getClockSequence() {
        return this.clockSequence;
    }

    private void incrementClockSequence() {
        this.clockSequence = (short)(this.clockSequence + 1);
        if (this.clockSequence > 16383) {
            this.clockSequence = 0;
        }
    }

    public long getUUIDTime() throws OverClockedException {
        long newTime = this.clock.getUUIDTime();
        if (newTime <= this.lastTimestamp) {
            this.incrementClockSequence();
        }
        this.lastTimestamp = newTime;
        return newTime;
    }

    public boolean equals(Object compareTo) {
        if (compareTo instanceof Node) {
            byte[] comp = ((Node)compareTo).getNodeIdentifier();
            return Arrays.equals(comp, this.id);
        }
        if (compareTo instanceof byte[]) {
            return Arrays.equals((byte[])compareTo, this.id);
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.id.length; ++i) {
            hash += this.id[i];
        }
        return hash;
    }

    public long getLastTimestamp() {
        return this.lastTimestamp;
    }
}

