/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid.clock;

import org.apache.commons.id.uuid.clock.Clock;
import org.apache.commons.id.uuid.clock.OverClockedException;
import org.apache.commons.id.uuid.clock.SystemClockImpl;

public final class ThreadClockImpl
extends Thread
implements Clock {
    public static final long DEFAULT_THREAD_LIFE = 200L;
    private static long threadLife = 200L;
    private static ThreadClockImpl worker = null;
    private static long currentTimeMillis;
    private static long expires;
    private long lastTimeMs = 0L;
    private int generatedThisInterval;
    private static short sysInterval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ThreadClockImpl() {
        if (worker != null) return;
        Class<ThreadClockImpl> clazz = ThreadClockImpl.class;
        synchronized (ThreadClockImpl.class) {
            worker = new ThreadClockImpl(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private ThreadClockImpl(boolean isWorkerThread) {
        this.setDaemon(true);
        this.setPriority(10);
        currentTimeMillis = System.currentTimeMillis();
        this.generatedThisInterval = 0;
        this.start();
    }

    public static long getThreadLife() {
        return threadLife;
    }

    public static void setThreadLife(long threadLifeLen) {
        threadLife = threadLifeLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            while (--expires >= 0L) {
                ThreadClockImpl.sleep(sysInterval);
                Class<ThreadClockImpl> clazz = ThreadClockImpl.class;
                // MONITORENTER : org.apache.commons.id.uuid.clock.ThreadClockImpl.class
                currentTimeMillis += (long)sysInterval;
                // MONITOREXIT : clazz
            }
            return;
        }
        catch (InterruptedException e) {
            System.out.println("Clock thread interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long getTimeSynchronized() throws OverClockedException {
        long current = 0L;
        Class<ThreadClockImpl> clazz = ThreadClockImpl.class;
        synchronized (ThreadClockImpl.class) {
            current = currentTimeMillis;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (current != this.lastTimeMs) {
                this.generatedThisInterval = 0;
                this.lastTimeMs = current;
            }
            if ((long)(this.generatedThisInterval + 1) >= 10000L * (long)sysInterval) {
                throw new OverClockedException();
            }
            return (current + 12219292800000L) * 10000L + (long)this.generatedThisInterval++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getUUIDTime() throws OverClockedException {
        if (worker.isAlive()) return this.getTimeSynchronized();
        Class<SystemClockImpl> clazz = SystemClockImpl.class;
        synchronized (SystemClockImpl.class) {
            currentTimeMillis = System.currentTimeMillis();
            worker.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.generatedThisInterval = 0;
            return this.getTimeSynchronized();
        }
    }

    static {
        expires = threadLife;
        sysInterval = 1;
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            sysInterval = (short)10;
        }
    }
}

