/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.id.IdentifierGenerator;
import org.apache.commons.id.uuid.Constants;
import org.apache.commons.id.uuid.UUID;

public final class VersionFourGenerator
implements IdentifierGenerator,
Constants {
    private static final Random regularRandom = new Random();
    private static Random secureRandom;
    private static String usePRNG;
    private static String usePRNGPackage;
    private static VersionFourGenerator generator;

    public static VersionFourGenerator getInstance() {
        if (generator == null) {
            generator = new VersionFourGenerator();
        }
        return generator;
    }

    public Object nextIdentifier() {
        return this.nextUUID(false);
    }

    public Object nextIdentifier(boolean secure) {
        return this.nextUUID(secure);
    }

    public UUID nextUUID() {
        return this.nextUUID(false);
    }

    private UUID nextUUID(boolean secure) {
        byte[] raw = new byte[16];
        if (secure) {
            if (secureRandom == null) {
                try {
                    secureRandom = usePRNGPackage != null ? SecureRandom.getInstance(usePRNG, usePRNGPackage) : SecureRandom.getInstance(usePRNG);
                }
                catch (NoSuchAlgorithmException nsae) {
                    secure = false;
                }
                catch (NoSuchProviderException nspe) {
                    secure = false;
                }
            }
            if (secureRandom != null) {
                secureRandom.nextBytes(raw);
            }
        } else {
            regularRandom.nextBytes(raw);
        }
        raw[6] = (byte)(raw[6] & 0xF);
        raw[6] = (byte)(raw[6] | 0x40);
        raw[8] = (byte)(raw[8] & 0x3F);
        raw[8] = (byte)(raw[8] | 0x80);
        return new UUID(raw);
    }

    public static void setPRNGProvider(String prngName, String packageName) {
        usePRNG = prngName;
        usePRNGPackage = packageName;
        secureRandom = null;
    }

    static {
        usePRNG = "SHA1PRNG";
        usePRNGPackage = "SUN";
    }
}

