/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid;

public final class Bytes {
    private Bytes() {
    }

    public static byte[] append(byte[] a, byte[] b) {
        byte[] z = new byte[a.length + b.length];
        System.arraycopy(a, 0, z, 0, a.length);
        System.arraycopy(b, 0, z, a.length, b.length);
        return z;
    }

    public static byte[] toBytes(long n) {
        return Bytes.toBytes(n, new byte[8]);
    }

    public static byte[] toBytes(long n, byte[] b) {
        b[7] = (byte)n;
        b[6] = (byte)(n >>>= 8);
        b[5] = (byte)(n >>>= 8);
        b[4] = (byte)(n >>>= 8);
        b[3] = (byte)(n >>>= 8);
        b[2] = (byte)(n >>>= 8);
        b[1] = (byte)(n >>>= 8);
        b[0] = (byte)(n >>>= 8);
        return b;
    }

    public static long toLong(byte[] b) {
        return ((long)b[7] & 0xFFL) + (((long)b[6] & 0xFFL) << 8) + (((long)b[5] & 0xFFL) << 16) + (((long)b[4] & 0xFFL) << 24) + (((long)b[3] & 0xFFL) << 32) + (((long)b[2] & 0xFFL) << 40) + (((long)b[1] & 0xFFL) << 48) + (((long)b[0] & 0xFFL) << 56);
    }

    public static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static int compareTo(byte[] lhs, byte[] rhs) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null) {
            return -1;
        }
        if (rhs == null) {
            return 1;
        }
        if (lhs.length != rhs.length) {
            return lhs.length < rhs.length ? -1 : 1;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (lhs[i] < rhs[i]) {
                return -1;
            }
            if (lhs[i] <= rhs[i]) continue;
            return 1;
        }
        return 0;
    }

    public static short toShort(byte[] b) {
        return (short)((b[1] & 0xFF) + ((b[0] & 0xFF) << 8));
    }
}

