/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.serial;

import org.apache.commons.id.AbstractStringIdentifierGenerator;

public class PrefixedLeftPaddedNumericGenerator
extends AbstractStringIdentifierGenerator {
    private final String prefix;
    private boolean wrap = true;
    private char[] count = null;
    private static final char NINE_CHAR = '9';

    public PrefixedLeftPaddedNumericGenerator(String prefix, boolean wrap, int size) {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (size < 1) {
            throw new IllegalArgumentException("size must be at least one");
        }
        if (size <= prefix.length()) {
            throw new IllegalArgumentException("size less prefix length must be at least one");
        }
        this.wrap = wrap;
        this.prefix = prefix;
        int countLength = size - prefix.length();
        this.count = new char[countLength];
        for (int i = 0; i < countLength; ++i) {
            this.count[i] = 48;
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public long maxLength() {
        return this.count.length + this.prefix.length();
    }

    public long minLength() {
        return this.count.length + this.prefix.length();
    }

    public int getSize() {
        return this.count.length + this.prefix.length();
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public String nextStringIdentifier() {
        block3: for (int i = this.count.length - 1; i >= 0; --i) {
            switch (this.count[i]) {
                case '9': {
                    this.count[i] = 48;
                    if (i != 0 || this.wrap) continue block3;
                    throw new IllegalStateException("The maximum number of identifiers has been reached");
                }
                default: {
                    int n = i;
                    this.count[n] = (char)(this.count[n] + '\u0001');
                    i = -1;
                }
            }
        }
        StringBuffer sb = new StringBuffer(this.prefix);
        sb.append(this.count);
        return sb.toString();
    }
}

