/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.serial;

import java.io.Serializable;
import org.apache.commons.id.AbstractStringIdentifierGenerator;

public class AlphanumericGenerator
extends AbstractStringIdentifierGenerator
implements Serializable {
    private static final long serialVersionUID = 20060120L;
    private boolean wrapping = true;
    private char[] count = null;
    private static final char Z_CHAR = 'z';
    private static final char NINE_CHAR = '9';

    public AlphanumericGenerator(boolean wrap) {
        this(wrap, 15);
    }

    public AlphanumericGenerator(boolean wrap, int size) {
        this.wrapping = wrap;
        if (size < 1) {
            throw new IllegalArgumentException("The size must be at least one");
        }
        this.count = new char[size];
        for (int i = 0; i < size; ++i) {
            this.count[i] = 48;
        }
    }

    public AlphanumericGenerator(boolean wrap, String initialValue) {
        this.wrapping = wrap;
        this.count = initialValue.toCharArray();
        for (int i = 0; i < this.count.length; ++i) {
            char ch = this.count[i];
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z') continue;
            throw new IllegalArgumentException("character " + this.count[i] + " is not valid");
        }
    }

    public long maxLength() {
        return this.count.length;
    }

    public long minLength() {
        return this.count.length;
    }

    public boolean isWrap() {
        return this.wrapping;
    }

    public void setWrap(boolean wrap) {
        this.wrapping = wrap;
    }

    public int getSize() {
        return this.count.length;
    }

    public synchronized String nextStringIdentifier() {
        block4: for (int i = this.count.length - 1; i >= 0; --i) {
            switch (this.count[i]) {
                case 'z': {
                    if (i == 0 && !this.wrapping) {
                        throw new IllegalStateException("The maximum number of identifiers has been reached");
                    }
                    this.count[i] = 48;
                    continue block4;
                }
                case '9': {
                    this.count[i] = 97;
                    i = -1;
                    continue block4;
                }
                default: {
                    int n = i;
                    this.count[n] = (char)(this.count[n] + '\u0001');
                    i = -1;
                }
            }
        }
        return new String(this.count);
    }
}

