/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.roller.util.ISO8601DateParser;

public abstract class DateUtil {
    public static final long millisInDay = 86400000L;
    private static final String formatDefaultDate = "dd.MM.yyyy";
    private static final String formatDefaultDateMinimal = "d.M.yy";
    private static final String formatDefaultTimestamp = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String formatFriendlyTimestamp = "dd.MM.yyyy HH:mm:ss";
    private static final String format6chars = "yyyyMM";
    private static final String format8chars = "yyyyMMdd";
    private static final String formatIso8601 = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String formatIso8601Day = "yyyy-MM-dd";
    private static final String formatRfc822 = "EEE, d MMM yyyy HH:mm:ss Z";

    public static Date getStartOfDay(Date day) {
        return DateUtil.getStartOfDay(day, Calendar.getInstance());
    }

    public static Date getStartOfDay(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal.getTime();
    }

    public static Date getEndOfDay(Date day) {
        return DateUtil.getEndOfDay(day, Calendar.getInstance());
    }

    public static Date getEndOfDay(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        return cal.getTime();
    }

    public static Date getStartOfHour(Date day) {
        return DateUtil.getStartOfHour(day, Calendar.getInstance());
    }

    public static Date getStartOfHour(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal.getTime();
    }

    public static Date getEndOfHour(Date day) {
        return DateUtil.getEndOfHour(day, Calendar.getInstance());
    }

    public static Date getEndOfHour(Date day, Calendar cal) {
        if (day == null || cal == null) {
            return day;
        }
        cal.setTime(day);
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        return cal.getTime();
    }

    public static Date getStartOfMinute(Date day) {
        return DateUtil.getStartOfMinute(day, Calendar.getInstance());
    }

    public static Date getStartOfMinute(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal.getTime();
    }

    public static Date getEndOfMinute(Date day) {
        return DateUtil.getEndOfMinute(day, Calendar.getInstance());
    }

    public static Date getEndOfMinute(Date day, Calendar cal) {
        if (day == null || cal == null) {
            return day;
        }
        cal.setTime(day);
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        return cal.getTime();
    }

    public static Date getStartOfMonth(Date day) {
        return DateUtil.getStartOfMonth(day, Calendar.getInstance());
    }

    public static Date getStartOfMonth(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getEndOfMonth(Date day) {
        return DateUtil.getEndOfMonth(day, Calendar.getInstance());
    }

    public static Date getEndOfMonth(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getNoonOfDay(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, 12);
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal.getTime();
    }

    public static Timestamp now() {
        return new Timestamp(new Date().getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date aDate, SimpleDateFormat aFormat) {
        if (aDate == null || aFormat == null) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = aFormat;
        synchronized (simpleDateFormat) {
            return aFormat.format(aDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(String aValue, SimpleDateFormat aFormat) throws ParseException {
        if (StringUtils.isEmpty((String)aValue) || aFormat == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = aFormat;
        synchronized (simpleDateFormat) {
            return aFormat.parse(aValue);
        }
    }

    public static boolean isValidDateRange(Date startDate, Date endDate) {
        return DateUtil.isValidDateRange(startDate, endDate, true);
    }

    public static boolean isValidDateRange(Date startDate, Date endDate, boolean equalOK) {
        if (startDate == null || endDate == null) {
            return false;
        }
        if (equalOK && startDate.equals(endDate)) {
            return true;
        }
        return endDate.after(startDate);
    }

    public static SimpleDateFormat defaultDateFormat() {
        return DateUtil.friendlyDateFormat(true);
    }

    public static SimpleDateFormat minimalDateFormat() {
        return DateUtil.friendlyDateFormat(true);
    }

    public static SimpleDateFormat fullDateFormat() {
        return DateUtil.friendlyDateFormat(false);
    }

    public static SimpleDateFormat friendlyDateFormat(boolean minimalFormat) {
        if (minimalFormat) {
            return new SimpleDateFormat(formatDefaultDateMinimal);
        }
        return new SimpleDateFormat(formatDefaultDate);
    }

    public static SimpleDateFormat defaultTimestampFormat() {
        return new SimpleDateFormat(formatDefaultTimestamp);
    }

    public static SimpleDateFormat friendlyTimestampFormat() {
        return new SimpleDateFormat(formatFriendlyTimestamp);
    }

    public static SimpleDateFormat get8charDateFormat() {
        return new SimpleDateFormat(format8chars);
    }

    public static SimpleDateFormat get6charDateFormat() {
        return new SimpleDateFormat(format6chars);
    }

    public static SimpleDateFormat getIso8601DateFormat() {
        return new SimpleDateFormat(formatIso8601);
    }

    public static SimpleDateFormat getIso8601DayDateFormat() {
        return new SimpleDateFormat(formatIso8601Day);
    }

    public static SimpleDateFormat getRfc822DateFormat() {
        return new SimpleDateFormat(formatRfc822, Locale.US);
    }

    public static String defaultDate(Date date) {
        return DateUtil.format(date, DateUtil.defaultDateFormat());
    }

    public static String minimalDate(Date date) {
        return DateUtil.format(date, DateUtil.minimalDateFormat());
    }

    public static String fullDate(Date date) {
        return DateUtil.format(date, DateUtil.fullDateFormat());
    }

    public static String friendlyDate(Date date, boolean minimalFormat) {
        return DateUtil.format(date, DateUtil.friendlyDateFormat(minimalFormat));
    }

    public static String friendlyDate(Date date) {
        return DateUtil.format(date, DateUtil.friendlyDateFormat(true));
    }

    public static String defaultTimestamp(Date date) {
        return DateUtil.format(date, DateUtil.defaultTimestampFormat());
    }

    public static String friendlyTimestamp(Date date) {
        return DateUtil.format(date, DateUtil.friendlyTimestampFormat());
    }

    public static String format8chars(Date date) {
        return DateUtil.format(date, DateUtil.get8charDateFormat());
    }

    public static String format6chars(Date date) {
        return DateUtil.format(date, DateUtil.get6charDateFormat());
    }

    public static String formatIso8601Day(Date date) {
        return DateUtil.format(date, DateUtil.getIso8601DayDateFormat());
    }

    public static String formatRfc822(Date date) {
        return DateUtil.format(date, DateUtil.getRfc822DateFormat());
    }

    public static String formatIso8601(Date date) {
        if (date == null) {
            return "";
        }
        String str = DateUtil.format(date, DateUtil.getIso8601DateFormat());
        StringBuffer sb = new StringBuffer();
        sb.append(str.substring(0, str.length() - 2));
        sb.append(":");
        sb.append(str.substring(str.length() - 2));
        return sb.toString();
    }

    public static Date parseIso8601(String value) throws Exception {
        return ISO8601DateParser.parse(value);
    }

    public static Date parseWeblogURLDateString(String dateString, TimeZone tz, Locale locale) {
        Date ret = new Date();
        SimpleDateFormat char8DateFormat = DateUtil.get8charDateFormat();
        SimpleDateFormat char6DateFormat = DateUtil.get6charDateFormat();
        if (dateString != null && dateString.length() == 8 && StringUtils.isNumeric((String)dateString)) {
            ParsePosition pos = new ParsePosition(0);
            ret = char8DateFormat.parse(dateString, pos);
            Date today = null;
            Calendar todayCal = Calendar.getInstance();
            todayCal = Calendar.getInstance(tz, locale);
            todayCal.setTime(new Date());
            today = todayCal.getTime();
            if (ret.after(today)) {
                ret = today;
            }
        } else if (dateString != null && dateString.length() == 6 && StringUtils.isNumeric((String)dateString)) {
            ParsePosition pos = new ParsePosition(0);
            ret = char6DateFormat.parse(dateString, pos);
            Calendar todayCal = Calendar.getInstance();
            todayCal = Calendar.getInstance(tz, locale);
            todayCal.setTime(new Date());
            Date today = todayCal.getTime();
            if (ret.after(today)) {
                ret = today;
            }
        }
        return ret;
    }
}

