/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.client;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcHttpTransport;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.util.HttpUtil;
import org.apache.xmlrpc.util.XmlRpcIOException;
import org.xml.sax.SAXException;

public class XmlRpcCommonsTransport
extends XmlRpcHttpTransport {
    private final HttpClient client = new HttpClient();
    private static final String userAgent = "Apache XML RPC 3.0 (Jakarta Commons httpclient Transport)";
    private PostMethod method;
    private int contentLength = -1;
    private XmlRpcHttpClientConfig config;

    public XmlRpcCommonsTransport(XmlRpcClient pClient) {
        super(pClient, userAgent);
    }

    protected void setContentLength(int pLength) {
        this.contentLength = pLength;
    }

    protected void initHttpHeaders(XmlRpcRequest pRequest) throws XmlRpcClientException {
        this.config = (XmlRpcHttpClientConfig)pRequest.getConfig();
        this.method = new PostMethod(this.config.getServerURL().toString());
        super.initHttpHeaders(pRequest);
        if (this.config.getConnectionTimeout() != 0) {
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(this.config.getConnectionTimeout());
        }
        if (this.config.getReplyTimeout() != 0) {
            this.client.getHttpConnectionManager().getParams().setSoTimeout(this.config.getConnectionTimeout());
        }
        this.method.getParams().setVersion(HttpVersion.HTTP_1_1);
    }

    protected void setRequestHeader(String pHeader, String pValue) {
        this.method.setRequestHeader(new Header(pHeader, pValue));
    }

    protected boolean isResponseGzipCompressed() {
        Header h = this.method.getResponseHeader("Content-Encoding");
        if (h == null) {
            return false;
        }
        return HttpUtil.isUsingGzipEncoding((String)h.getValue());
    }

    protected InputStream getInputStream() throws XmlRpcException {
        try {
            return this.method.getResponseBodyAsStream();
        }
        catch (HttpException e) {
            throw new XmlRpcClientException("Error in HTTP transport: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlRpcClientException("I/O error in server communication: " + e.getMessage(), e);
        }
    }

    protected void setCredentials(XmlRpcHttpClientConfig pConfig) throws XmlRpcClientException {
        String userName = pConfig.getBasicUserName();
        if (userName != null) {
            String enc = pConfig.getBasicEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            this.client.getParams().setParameter("http.protocol.credential-charset", (Object)enc);
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(userName, pConfig.getBasicPassword());
            AuthScope scope = new AuthScope(null, -1, null, AuthScope.ANY_SCHEME);
            this.client.getState().setCredentials(scope, (Credentials)creds);
            this.client.getParams().setAuthenticationPreemptive(true);
        }
    }

    protected void close() throws XmlRpcClientException {
        this.method.releaseConnection();
    }

    protected boolean isResponseGzipCompressed(XmlRpcStreamRequestConfig pConfig) {
        Header h = this.method.getResponseHeader("Content-Encoding");
        if (h == null) {
            return false;
        }
        return HttpUtil.isUsingGzipEncoding((String)h.getValue());
    }

    protected void writeRequest(final XmlRpcStreamTransport.ReqWriter pWriter) throws XmlRpcException {
        this.method.setRequestEntity(new RequestEntity(){

            public boolean isRepeatable() {
                return XmlRpcCommonsTransport.this.contentLength != -1;
            }

            public void writeRequest(OutputStream pOut) throws IOException {
                try {
                    FilterOutputStream ostream = XmlRpcCommonsTransport.this.isUsingByteArrayOutput(XmlRpcCommonsTransport.this.config) ? new FilterOutputStream(pOut){

                        public void close() throws IOException {
                            this.flush();
                        }
                    } : new BufferedOutputStream(pOut){

                        public void close() throws IOException {
                            this.flush();
                        }
                    };
                    pWriter.write(ostream);
                }
                catch (XmlRpcException e) {
                    throw new XmlRpcIOException((Throwable)e);
                }
                catch (SAXException e) {
                    throw new XmlRpcIOException((Throwable)e);
                }
            }

            public long getContentLength() {
                return XmlRpcCommonsTransport.this.contentLength;
            }

            public String getContentType() {
                return "text/xml";
            }
        });
        try {
            this.client.executeMethod((HttpMethod)this.method);
        }
        catch (XmlRpcIOException e) {
            Throwable t = e.getLinkedException();
            if (t instanceof XmlRpcException) {
                throw (XmlRpcException)t;
            }
            throw new XmlRpcException("Unexpected exception: " + t.getMessage(), t);
        }
        catch (IOException e) {
            throw new XmlRpcException("I/O error while communicating with HTTP server: " + e.getMessage(), (Throwable)e);
        }
    }
}

