/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderFactory;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ValidatorContext;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelegatingValidatorContext
implements ValidatorContext {
    private LocaleProvider localeProvider;
    private TextProvider textProvider;
    private ValidationAware validationAware;

    public DelegatingValidatorContext(ValidationAware validationAware, TextProvider textProvider, LocaleProvider localeProvider) {
        this.textProvider = textProvider;
        this.validationAware = validationAware;
        this.localeProvider = localeProvider;
    }

    public DelegatingValidatorContext(Object object) {
        this.localeProvider = DelegatingValidatorContext.makeLocaleProvider(object);
        this.validationAware = DelegatingValidatorContext.makeValidationAware(object);
        this.textProvider = DelegatingValidatorContext.makeTextProvider(object, this.localeProvider);
    }

    public DelegatingValidatorContext(Class clazz) {
        this.localeProvider = new ActionContextLocaleProvider();
        this.textProvider = new TextProviderFactory().createInstance(clazz, this.localeProvider);
        this.validationAware = new LoggingValidationAware(clazz);
    }

    public void setActionErrors(Collection errorMessages) {
        this.validationAware.setActionErrors(errorMessages);
    }

    public Collection getActionErrors() {
        return this.validationAware.getActionErrors();
    }

    public void setActionMessages(Collection messages) {
        this.validationAware.setActionMessages(messages);
    }

    public Collection getActionMessages() {
        return this.validationAware.getActionMessages();
    }

    public void setFieldErrors(Map errorMap) {
        this.validationAware.setFieldErrors(errorMap);
    }

    public Map getFieldErrors() {
        return this.validationAware.getFieldErrors();
    }

    public String getFullFieldName(String fieldName) {
        return fieldName;
    }

    public Locale getLocale() {
        return this.localeProvider.getLocale();
    }

    public String getText(String aTextName) {
        return this.textProvider.getText(aTextName);
    }

    public String getText(String aTextName, String defaultValue) {
        return this.textProvider.getText(aTextName, defaultValue);
    }

    public String getText(String aTextName, String defaultValue, String obj) {
        return this.textProvider.getText(aTextName, defaultValue, obj);
    }

    public String getText(String aTextName, List args) {
        return this.textProvider.getText(aTextName, args);
    }

    public String getText(String key, String[] args) {
        return this.textProvider.getText(key, args);
    }

    public String getText(String aTextName, String defaultValue, List args) {
        return this.textProvider.getText(aTextName, defaultValue, args);
    }

    public String getText(String key, String defaultValue, String[] args) {
        return this.textProvider.getText(key, defaultValue, args);
    }

    public ResourceBundle getTexts(String aBundleName) {
        return this.textProvider.getTexts(aBundleName);
    }

    public String getText(String key, String defaultValue, List args, ValueStack stack) {
        return this.textProvider.getText(key, defaultValue, args, stack);
    }

    public String getText(String key, String defaultValue, String[] args, ValueStack stack) {
        return this.textProvider.getText(key, defaultValue, args, stack);
    }

    public ResourceBundle getTexts() {
        return this.textProvider.getTexts();
    }

    public void addActionError(String anErrorMessage) {
        this.validationAware.addActionError(anErrorMessage);
    }

    public void addActionMessage(String aMessage) {
        this.validationAware.addActionMessage(aMessage);
    }

    public void addFieldError(String fieldName, String errorMessage) {
        this.validationAware.addFieldError(fieldName, errorMessage);
    }

    public boolean hasActionErrors() {
        return this.validationAware.hasActionErrors();
    }

    public boolean hasActionMessages() {
        return this.validationAware.hasActionMessages();
    }

    public boolean hasErrors() {
        return this.validationAware.hasErrors();
    }

    public boolean hasFieldErrors() {
        return this.validationAware.hasFieldErrors();
    }

    public static TextProvider makeTextProvider(Object object, LocaleProvider localeProvider) {
        if (object instanceof TextProvider) {
            return (TextProvider)object;
        }
        return new TextProviderFactory().createInstance(object.getClass(), localeProvider);
    }

    protected static LocaleProvider makeLocaleProvider(Object object) {
        if (object instanceof LocaleProvider) {
            return (LocaleProvider)object;
        }
        return new ActionContextLocaleProvider();
    }

    protected static ValidationAware makeValidationAware(Object object) {
        if (object instanceof ValidationAware) {
            return (ValidationAware)object;
        }
        return new LoggingValidationAware(object);
    }

    protected void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    protected TextProvider getTextProvider() {
        return this.textProvider;
    }

    protected void setValidationAware(ValidationAware validationAware) {
        this.validationAware = validationAware;
    }

    protected ValidationAware getValidationAware() {
        return this.validationAware;
    }

    private static class LoggingValidationAware
    implements ValidationAware {
        private Log log;

        public LoggingValidationAware(Class clazz) {
            this.log = LogFactory.getLog((Class)clazz);
        }

        public LoggingValidationAware(Object obj) {
            this.log = LogFactory.getLog(obj.getClass());
        }

        public void setActionErrors(Collection errorMessages) {
            for (String s : errorMessages) {
                this.addActionError(s);
            }
        }

        public Collection getActionErrors() {
            return null;
        }

        public void setActionMessages(Collection messages) {
            for (String s : messages) {
                this.addActionMessage(s);
            }
        }

        public Collection getActionMessages() {
            return null;
        }

        public void setFieldErrors(Map errorMap) {
            for (Map.Entry entry : errorMap.entrySet()) {
                this.addFieldError((String)entry.getKey(), (String)entry.getValue());
            }
        }

        public Map getFieldErrors() {
            return null;
        }

        public void addActionError(String anErrorMessage) {
            this.log.error((Object)("Validation error: " + anErrorMessage));
        }

        public void addActionMessage(String aMessage) {
            this.log.info((Object)("Validation Message: " + aMessage));
        }

        public void addFieldError(String fieldName, String errorMessage) {
            this.log.error((Object)("Validation error for " + fieldName + ":" + errorMessage));
        }

        public boolean hasActionErrors() {
            return false;
        }

        public boolean hasActionMessages() {
            return false;
        }

        public boolean hasErrors() {
            return false;
        }

        public boolean hasFieldErrors() {
            return false;
        }
    }

    private static class ActionContextLocaleProvider
    implements LocaleProvider {
        private ActionContextLocaleProvider() {
        }

        public Locale getLocale() {
            return ActionContext.getContext().getLocale();
        }
    }
}

