/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor.annotations;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.interceptor.annotations.After;
import com.opensymphony.xwork2.interceptor.annotations.Before;
import com.opensymphony.xwork2.interceptor.annotations.BeforeResult;
import com.opensymphony.xwork2.util.AnnotationUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AnnotationWorkflowInterceptor
implements Interceptor,
PreResultListener {
    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        invocation.addPreResultListener(this);
        List<Method> methods = AnnotationUtils.findAnnotatedMethods(action.getClass(), Before.class);
        if (methods != null && methods.size() > 0) {
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method method1, Method method2) {
                    return method2.getAnnotation(Before.class).priority() - method1.getAnnotation(Before.class).priority();
                }
            });
            for (Method m : methods) {
                String resultCode = (String)m.invoke(action, (Object[])null);
                if (resultCode == null) continue;
                return resultCode;
            }
        }
        String invocationResult = invocation.invoke();
        methods = AnnotationUtils.findAnnotatedMethods(action.getClass(), After.class);
        if (methods != null && methods.size() > 0) {
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method method1, Method method2) {
                    return method2.getAnnotation(After.class).priority() - method1.getAnnotation(After.class).priority();
                }
            });
            for (Method m : methods) {
                m.invoke(action, (Object[])null);
            }
        }
        return invocationResult;
    }

    public void destroy() {
    }

    public void init() {
    }

    public void beforeResult(ActionInvocation invocation, String resultCode) {
        Object action = invocation.getAction();
        List<Method> methods = AnnotationUtils.findAnnotatedMethods(action.getClass(), BeforeResult.class);
        if (methods != null && methods.size() > 0) {
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method method1, Method method2) {
                    return method2.getAnnotation(BeforeResult.class).priority() - method1.getAnnotation(BeforeResult.class).priority();
                }
            });
            for (Method m : methods) {
                try {
                    m.invoke(action, (Object[])null);
                }
                catch (Exception e) {
                    throw new XWorkException(e);
                }
            }
        }
    }
}

