/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class Technorati {
    private String mKey = null;

    public Technorati(String key) {
        this.mKey = key;
    }

    public Technorati(String key, String proxy, int proxyPort) {
        this(key);
        System.setProperty("proxySet", "true");
        System.setProperty("http.proxyHost", proxy);
        System.setProperty("http.proxyPort", Integer.toString(proxyPort));
    }

    public Technorati() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/technorati.license");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        this.mKey = br.readLine();
    }

    public Technorati(String proxy, int proxyPort) throws Exception {
        this();
        System.setProperty("proxySet", "true");
        System.setProperty("http.proxyHost", proxy);
        System.setProperty("http.proxyPort", Integer.toString(proxyPort));
    }

    public Result getLinkCosmos(String url) throws Exception {
        return new Result("http://api.technorati.com/cosmos", url, "links");
    }

    public Result getWeblogCosmos(String url) throws Exception {
        return new Result("http://api.technorati.com/cosmos", url, "weblog");
    }

    public Result getBloginfo(String url) throws Exception {
        return new Result("http://api.technorati.com/bloginfo", url, null);
    }

    public Result getOutbound(String url) throws Exception {
        return new Result("http://api.technorati.com/outbound", url, null);
    }

    protected Document getRawResults(String urlString, Map args) throws Exception {
        int count = 0;
        Iterator keys = args.keySet().iterator();
        while (keys.hasNext()) {
            String sep;
            String string = sep = count++ == 0 ? "?" : "&";
            String name = (String)keys.next();
            if (args.get(name) == null) continue;
            urlString = urlString + sep + name + "=" + args.get(name);
        }
        URL url = new URL(urlString);
        URLConnection conn = url.openConnection();
        conn.connect();
        SAXBuilder builder = new SAXBuilder();
        return builder.build(conn.getInputStream());
    }

    protected String getString(Element elem, String path) throws Exception {
        XPath xpath = XPath.newInstance((String)path);
        Element e = (Element)xpath.selectSingleNode((Object)elem);
        return e != null ? e.getText() : null;
    }

    protected int getInt(Element elem, String path) throws Exception {
        XPath xpath = XPath.newInstance((String)path);
        Element e = (Element)xpath.selectSingleNode((Object)elem);
        return e != null ? Integer.parseInt(e.getText()) : 0;
    }

    public class Weblog {
        private String mName = null;
        private String mUrl = null;
        private String mRssurl = null;
        private String mLastupdate = null;
        private String mNearestpermalink = null;
        private String mExcerpt = null;
        private int mInboundlinks = 0;
        private int mInboundblogs = 0;

        public Weblog(Element elem) throws Exception {
            this.mName = Technorati.this.getString(elem, "name");
            this.mUrl = Technorati.this.getString(elem, "url");
            this.mRssurl = Technorati.this.getString(elem, "rssurl");
            this.mLastupdate = Technorati.this.getString(elem, "lastupdate");
            this.mNearestpermalink = Technorati.this.getString(elem, "nearestpermalink");
            this.mExcerpt = Technorati.this.getString(elem, "excerpt");
            try {
                this.mInboundlinks = Technorati.this.getInt(elem, "inboundlinks");
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                this.mInboundblogs = Technorati.this.getInt(elem, "inboundblogs");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getName() {
            return this.mName;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public String getRssurl() {
            return this.mRssurl;
        }

        public int getInboundblogs() {
            return this.mInboundblogs;
        }

        public int getInboundlinks() {
            return this.mInboundlinks;
        }

        public String getLastupdate() {
            return this.mLastupdate;
        }

        public String getNearestpermalink() {
            return this.mNearestpermalink;
        }

        public String getExcerpt() {
            return this.mExcerpt;
        }
    }

    public class Result {
        private Weblog mWeblog = null;
        private Collection mWeblogs = new ArrayList();

        protected Result(String apiUrl, String url, String type) throws Exception {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("url", url);
            args.put("type", type);
            args.put("format", "xml");
            args.put("key", Technorati.this.mKey);
            int start = 0;
            boolean repeat = true;
            XPath itemsPath = XPath.newInstance((String)"/tapi/document/item/weblog");
            while (repeat) {
                Document doc = Technorati.this.getRawResults(apiUrl, args);
                Element elem = doc.getRootElement();
                String error = Technorati.this.getString(elem, "/tapi/document/result/error");
                if (error != null) {
                    throw new Exception(error);
                }
                if (this.mWeblog == null) {
                    XPath p = XPath.newInstance((String)"/tapi/document/result/weblog");
                    Element w = (Element)p.selectSingleNode((Object)doc);
                    this.mWeblog = new Weblog(w);
                }
                int count = 0;
                for (Element element : itemsPath.selectNodes((Object)doc)) {
                    Weblog w = new Weblog(element);
                    this.mWeblogs.add(w);
                    ++count;
                }
                if (count < 20) {
                    repeat = false;
                    continue;
                }
                args.put("start", new Integer(start += 20));
            }
        }

        public Weblog getWeblog() {
            return this.mWeblog;
        }

        public Collection getWeblogs() {
            return this.mWeblogs;
        }
    }
}

