/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.tasks;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.business.Planet;
import org.apache.roller.planet.business.PlanetFactory;
import org.apache.roller.planet.business.PlanetManager;
import org.apache.roller.planet.config.PlanetConfig;
import org.apache.roller.planet.tasks.PlanetTask;
import org.apache.roller.planet.tasks.StaticPlanetModel;
import org.apache.roller.util.OldUtilities;
import org.apache.roller.util.UtilitiesModel;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.texen.Generator;

public class GeneratePlanetTask
extends PlanetTask {
    private static Log log = LogFactory.getLog(GeneratePlanetTask.class);

    public void run() {
        try {
            Planet planet = PlanetFactory.getPlanet();
            PlanetManager planetManager = planet.getPlanetManager();
            String mainPage = PlanetConfig.getProperty("planet.aggregator.mainPage");
            String templateDir = PlanetConfig.getProperty("planet.aggregator.template.dir");
            String outputDir = PlanetConfig.getProperty("planet.aggregator.output.dir");
            log.info((Object)"Calling Velocity Texen to generate Planet files");
            log.info((Object)("   Control file       [" + mainPage + "]"));
            log.info((Object)("   Template directory [" + templateDir + "]"));
            log.info((Object)("   Output directory   [" + outputDir + "]"));
            VelocityEngine engine = new VelocityEngine();
            engine.setProperty("resource.loader", (Object)"file");
            engine.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            engine.setProperty("file.resource.loader.path", (Object)templateDir);
            engine.init();
            VelocityContext context = new VelocityContext();
            context.put("date", (Object)new Date());
            context.put("utils", (Object)new UtilitiesModel());
            context.put("utilities", (Object)new OldUtilities());
            context.put("planet", (Object)new StaticPlanetModel());
            File outputDirObj = new File(outputDir);
            if (!outputDirObj.exists()) {
                outputDirObj.mkdirs();
            }
            List groups = Collections.EMPTY_LIST;
            for (String groupHandle : groups) {
                String groupDirName = outputDirObj + File.separator + groupHandle;
                File groupDir = new File(groupDirName);
                if (groupDir.exists()) continue;
                groupDir.mkdirs();
            }
            Generator generator = Generator.getInstance();
            generator.setVelocityEngine(engine);
            generator.setOutputEncoding("UTF-8");
            generator.setInputEncoding("UTF-8");
            generator.setOutputPath(outputDir);
            generator.setTemplatePath(templateDir);
            generator.parse(mainPage, (Context)context);
            generator.shutdown();
        }
        catch (Exception e) {
            log.error((Object)"ERROR generating planet", (Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        GeneratePlanetTask task = new GeneratePlanetTask();
        task.initialize();
        task.run();
    }
}

