/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.config.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.roller.planet.config.runtime.ConfigDef;
import org.apache.roller.planet.config.runtime.DisplayGroup;
import org.apache.roller.planet.config.runtime.PropertyDef;
import org.apache.roller.planet.config.runtime.RuntimeConfigDefs;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class RuntimeConfigDefsParser {
    public RuntimeConfigDefs unmarshall(InputStream instream) throws IOException, JDOMException {
        if (instream == null) {
            throw new IOException("InputStream is null!");
        }
        RuntimeConfigDefs configs = new RuntimeConfigDefs();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(instream);
        Element root = doc.getRootElement();
        List configdefs = root.getChildren("config-def");
        for (Element e : configdefs) {
            configs.addConfigDef(this.elementToConfigDef(e));
        }
        return configs;
    }

    private ConfigDef elementToConfigDef(Element element) {
        ConfigDef configdef = new ConfigDef();
        configdef.setName(element.getAttributeValue("name"));
        List displaygroups = element.getChildren("display-group");
        for (Element e : displaygroups) {
            configdef.addDisplayGroup(this.elementToDisplayGroup(e));
        }
        return configdef;
    }

    private DisplayGroup elementToDisplayGroup(Element element) {
        DisplayGroup displaygroup = new DisplayGroup();
        displaygroup.setName(element.getAttributeValue("name"));
        displaygroup.setKey(element.getAttributeValue("key"));
        List displaygroups = element.getChildren("property-def");
        for (Element e : displaygroups) {
            displaygroup.addPropertyDef(this.elementToPropertyDef(e));
        }
        return displaygroup;
    }

    private PropertyDef elementToPropertyDef(Element element) {
        PropertyDef prop = new PropertyDef();
        prop.setName(element.getAttributeValue("name"));
        prop.setKey(element.getAttributeValue("key"));
        prop.setType(element.getChildText("type"));
        prop.setDefaultValue(element.getChildText("default-value"));
        if (element.getChild("rows") != null) {
            prop.setRows(element.getChildText("rows"));
        }
        if (element.getChild("cols") != null) {
            prop.setCols(element.getChildText("cols"));
        }
        return prop;
    }
}

