/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business.startup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.business.DatabaseProvider;
import org.apache.roller.planet.business.startup.StartupException;

public final class PlanetStartup {
    private static final Log log = LogFactory.getLog(PlanetStartup.class);
    private static boolean prepared = false;
    private static DatabaseProvider dbProvider = null;
    private static StartupException dbProviderException = null;

    private PlanetStartup() {
    }

    public static boolean isPrepared() {
        return prepared;
    }

    public static DatabaseProvider getDatabaseProvider() {
        if (dbProvider == null) {
            throw new IllegalStateException("Roller Planet has not been prepared yet");
        }
        return dbProvider;
    }

    public static StartupException getDatabaseProviderException() {
        return dbProviderException;
    }

    public static void prepare() throws StartupException {
        try {
            dbProvider = new DatabaseProvider();
        }
        catch (StartupException ex) {
            dbProviderException = ex;
            throw ex;
        }
        prepared = true;
    }
}

