/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business.hibernate;

import com.google.inject.Singleton;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.roller.planet.PlanetException;
import org.apache.roller.planet.config.PlanetConfig;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

@Singleton
public class HibernatePersistenceStrategy {
    private static final Log log = LogFactory.getLog(HibernatePersistenceStrategy.class);
    private final SessionFactory sessionFactory;

    protected HibernatePersistenceStrategy() throws PlanetException {
        Configuration config = new Configuration();
        config.configure("/META-INF/planet-hibernate.cfg.xml");
        Properties props = new Properties();
        Enumeration keys = PlanetConfig.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("hibernate.")) continue;
            String value = PlanetConfig.getProperty(key);
            props.setProperty(key, value);
        }
        config.addProperties(props);
        this.sessionFactory = config.buildSessionFactory();
    }

    public org.hibernate.Session getSession() {
        log.debug((Object)"Obtaining Hibernate Session");
        Session session = this.sessionFactory.getCurrentSession();
        session.beginTransaction();
        return session;
    }

    public void flush() throws PlanetException {
        org.hibernate.Session session = this.getSession();
        try {
            log.debug((Object)"Flushing Hibernate Session");
            session.flush();
            log.debug((Object)"Committing Hibernate Transaction");
            session.getTransaction().commit();
        }
        catch (Throwable t) {
            this.release();
            throw new PlanetException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        block9: {
            try {
                Session session = this.sessionFactory.getCurrentSession();
                if (session == null || !session.isOpen()) break block9;
                log.debug((Object)"Closing Hibernate Session");
                try {
                    Transaction tx = session.getTransaction();
                    if (tx != null && tx.isActive()) {
                        log.debug((Object)"Forcing rollback on active transaction");
                        tx.rollback();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"ERROR doing Hibernate rollback", t);
                }
                finally {
                    if (session.isOpen()) {
                        session.close();
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"ERROR closing Hibernate Session", t);
            }
        }
    }

    public Object load(String id, Class clazz) throws PlanetException {
        if (id == null || clazz == null) {
            throw new PlanetException("Cannot load objects when value is null");
        }
        return this.getSession().get(clazz, (Serializable)((Object)id));
    }

    public void store(Object obj) throws HibernateException {
        if (obj == null) {
            throw new HibernateException("Cannot save null object");
        }
        org.hibernate.Session session = this.getSession();
        session.saveOrUpdate(obj);
    }

    public void remove(Object obj) throws HibernateException {
        if (obj == null) {
            throw new HibernateException("Cannot remove null object");
        }
        this.getSession().delete(obj);
    }
}

