/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.planet.business;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.roller.planet.business.PlanetFactory;
import org.apache.roller.planet.business.PlanetManager;
import org.apache.roller.planet.business.URLStrategy;
import org.apache.roller.planet.config.PlanetRuntimeConfig;

public class MultiPlanetURLStrategy
implements URLStrategy {
    public String getPlanetURL(String planet) {
        if (planet == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        PlanetManager mgr = PlanetFactory.getPlanet().getPlanetManager();
        url.append(PlanetRuntimeConfig.getProperty("site.absoluteurl"));
        url.append("/").append(planet).append("/");
        return url.toString();
    }

    public String getPlanetGroupURL(String planet, String group, int pageNum) {
        if (planet == null || group == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        url.append(this.getPlanetURL(planet));
        url.append("group/").append(group).append("/");
        if (pageNum > 0) {
            url.append("?page=");
            url.append(pageNum);
        }
        return url.toString();
    }

    public String getPlanetGroupFeedURL(String planet, String group, String format) {
        if (planet == null || group == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        url.append(this.getPlanetGroupURL(planet, group, -1));
        url.append("feed/").append(format);
        return url.toString();
    }

    public String getPlanetGroupOpmlURL(String planet, String group) {
        if (planet == null || group == null) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        url.append(this.getPlanetGroupURL(planet, group, -1));
        url.append("opml");
        return url.toString();
    }

    public String getQueryString(Map params) {
        if (params == null) {
            return null;
        }
        StringBuffer queryString = new StringBuffer();
        for (String key : params.keySet()) {
            String value = (String)params.get(key);
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            queryString.append(key);
            queryString.append("=");
            queryString.append(value);
        }
        return queryString.toString();
    }

    public String encode(String str) {
        String encodedStr = str;
        try {
            encodedStr = URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encodedStr;
    }

    public String decode(String str) {
        String decodedStr = str;
        try {
            decodedStr = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedStr;
    }
}

