/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.BCClass;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Numbers;

public class ConstantInstruction
extends TypedInstruction {
    private int _arg = -1;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    ConstantInstruction(Code owner) {
        super(owner);
    }

    ConstantInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    int getLength() {
        switch (this.getOpcode()) {
            case 16: 
            case 18: {
                return super.getLength() + 1;
            }
            case 17: 
            case 19: 
            case 20: {
                return super.getLength() + 2;
            }
        }
        return super.getLength();
    }

    public int getStackChange() {
        String type = this.getTypeName();
        if (Double.TYPE.getName().equals(type) || Long.TYPE.getName().equals(type)) {
            return 2;
        }
        return 1;
    }

    public int getLogicalStackChange() {
        return 1;
    }

    public String getTypeName() {
        int opcode = this.getOpcode();
        switch (opcode) {
            case 0: {
                return null;
            }
            case 1: {
                return (class$java$lang$Object == null ? (class$java$lang$Object = ConstantInstruction.class$("java.lang.Object")) : class$java$lang$Object).getName();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                return Integer.TYPE.getName();
            }
            case 9: 
            case 10: {
                return Long.TYPE.getName();
            }
            case 11: 
            case 12: 
            case 13: {
                return Float.TYPE.getName();
            }
            case 14: 
            case 15: {
                return Double.TYPE.getName();
            }
        }
        Entry entry = this.getPool().getEntry(this._arg);
        switch (entry.getType()) {
            case 1: 
            case 8: {
                return (class$java$lang$String == null ? (class$java$lang$String = ConstantInstruction.class$("java.lang.String")) : class$java$lang$String).getName();
            }
            case 3: {
                return Integer.TYPE.getName();
            }
            case 4: {
                return Float.TYPE.getName();
            }
            case 5: {
                return Long.TYPE.getName();
            }
            case 6: {
                return Double.TYPE.getName();
            }
            case 7: {
                return (class$java$lang$Class == null ? (class$java$lang$Class = ConstantInstruction.class$("java.lang.Class")) : class$java$lang$Class).getName();
            }
        }
        return null;
    }

    public TypedInstruction setType(String type) {
        throw new UnsupportedOperationException("Use setValue");
    }

    public Object getValue() {
        int opcode = this.getOpcode();
        switch (opcode) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Numbers.valueOf(opcode - 3);
            }
            case 9: 
            case 10: {
                return Numbers.valueOf((long)(opcode - 9));
            }
            case 11: 
            case 12: 
            case 13: {
                return new Float(opcode - 11);
            }
            case 14: 
            case 15: {
                return new Double(opcode - 14);
            }
            case 16: 
            case 17: {
                return Numbers.valueOf(this._arg);
            }
        }
        Entry entry = this.getPool().getEntry(this._arg);
        Object val = ((ConstantEntry)((Object)entry)).getConstant();
        if (entry.getType() == 7) {
            return this.getProject().getNameCache().getExternalForm((String)val, false);
        }
        return val;
    }

    public ConstantInstruction setValue(Object value) {
        if (value instanceof Boolean) {
            value = Numbers.valueOf((Boolean)value != false ? 1 : 0);
        } else if (value instanceof Character) {
            value = Numbers.valueOf(((Character)value).charValue());
        } else if (value instanceof Byte) {
            value = Numbers.valueOf(((Byte)value).intValue());
        } else if (value instanceof Short) {
            value = Numbers.valueOf(((Short)value).intValue());
        } else if (!(value == null || value instanceof Number || value instanceof String || value instanceof Class || value instanceof BCClass)) {
            throw new IllegalArgumentException("value = " + value);
        }
        this.calculateOpcode(value, false);
        return this;
    }

    public String getStringValue() {
        return (String)this.getValue();
    }

    public int getIntValue() {
        Object value = this.getValue();
        return value == null ? 0 : ((Number)value).intValue();
    }

    public long getLongValue() {
        Object value = this.getValue();
        return value == null ? 0L : ((Number)value).longValue();
    }

    public float getFloatValue() {
        Object value = this.getValue();
        return value == null ? 0.0f : ((Number)value).floatValue();
    }

    public double getDoubleValue() {
        Object value = this.getValue();
        return value == null ? 0.0 : ((Number)value).doubleValue();
    }

    public String getClassNameValue() {
        return (String)this.getValue();
    }

    public ConstantInstruction setNull() {
        this.calculateOpcode(null, false);
        return this;
    }

    public ConstantInstruction setValue(String value) {
        this.calculateOpcode(value, false);
        return this;
    }

    public ConstantInstruction setValue(Class value) {
        this.calculateOpcode(value, false);
        return this;
    }

    public ConstantInstruction setValue(BCClass value) {
        this.calculateOpcode(value, false);
        return this;
    }

    public ConstantInstruction setValue(int value) {
        this.calculateOpcode(Numbers.valueOf(value), false);
        return this;
    }

    public ConstantInstruction setValue(long value) {
        this.calculateOpcode(Numbers.valueOf(value), false);
        return this;
    }

    public ConstantInstruction setValue(float value) {
        this.calculateOpcode(new Float(value), false);
        return this;
    }

    public ConstantInstruction setValue(double value) {
        this.calculateOpcode(new Double(value), false);
        return this;
    }

    public ConstantInstruction setValue(boolean value) {
        return this.setValue(value ? 1 : 0);
    }

    public ConstantInstruction setValue(short value) {
        return this.setValue((int)value);
    }

    public ConstantInstruction setValue(char value) {
        return this.setValue((int)value);
    }

    public boolean equalsInstruction(Instruction other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConstantInstruction)) {
            return false;
        }
        Object value = this.getValue();
        Object otherValue = ((ConstantInstruction)other).getValue();
        return value == null || otherValue == null || value.equals(otherValue);
    }

    public void acceptVisit(BCVisitor visit) {
        visit.enterConstantInstruction(this);
        visit.exitConstantInstruction(this);
    }

    void read(Instruction orig) {
        super.read(orig);
        ConstantInstruction ci = (ConstantInstruction)orig;
        this.calculateOpcode(ci.getValue(), ci.getOpcode() == 19);
    }

    void read(DataInput in) throws IOException {
        super.read(in);
        switch (this.getOpcode()) {
            case 16: 
            case 18: {
                this._arg = in.readUnsignedByte();
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                this._arg = in.readUnsignedShort();
            }
        }
    }

    void write(DataOutput out) throws IOException {
        super.write(out);
        switch (this.getOpcode()) {
            case 16: 
            case 18: {
                out.writeByte(this._arg);
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                out.writeShort(this._arg);
            }
        }
    }

    private void calculateOpcode(Object value, boolean wide) {
        this._arg = -1;
        if (value == null) {
            this.setOpcode(1);
        } else if (value instanceof Float) {
            float floatVal = ((Float)value).floatValue();
            if (floatVal == 0.0f || floatVal == 1.0f || floatVal == 2.0f) {
                this.setOpcode(11 + (int)floatVal);
            } else {
                this._arg = this.getPool().findFloatEntry(floatVal, true);
                this.setOpcode(this._arg > 255 || wide ? 19 : 18);
            }
        } else if (value instanceof Long) {
            long longVal = (Long)value;
            if (longVal == 0L || longVal == 1L) {
                this.setOpcode(9 + (int)longVal);
            } else {
                this._arg = this.getPool().findLongEntry(longVal, true);
                this.setOpcode(20);
            }
        } else if (value instanceof Double) {
            double doubleVal = (Double)value;
            if (doubleVal == 0.0 || doubleVal == 1.0) {
                this.setOpcode(14 + (int)doubleVal);
            } else {
                this._arg = this.getPool().findDoubleEntry(doubleVal, true);
                this.setOpcode(20);
            }
        } else if (value instanceof Integer) {
            int intVal = (Integer)value;
            if (intVal >= -1 && intVal <= 5) {
                this.setOpcode(3 + intVal);
            } else if (intVal >= -128 && intVal < 128) {
                this.setOpcode(16);
                this._arg = intVal;
            } else if (intVal >= Short.MIN_VALUE && intVal < 32768) {
                this.setOpcode(17);
                this._arg = intVal;
            } else {
                this._arg = this.getPool().findIntEntry(intVal, true);
                this.setOpcode(this._arg > 255 || wide ? 19 : 18);
            }
        } else if (value instanceof String) {
            this._arg = this.getPool().findStringEntry((String)value, true);
            this.setOpcode(this._arg > 255 || wide ? 19 : 18);
        } else if (value instanceof Class) {
            String name = this.getProject().getNameCache().getInternalForm(((Class)value).getName(), false);
            this._arg = this.getPool().findClassEntry(name, true);
            this.setOpcode(19);
        } else if (value instanceof BCClass) {
            BCClass bc = (BCClass)value;
            ClassEntry entry = (ClassEntry)bc.getPool().getEntry(bc.getIndex());
            this._arg = bc.getPool() == this.getPool() ? this.getPool().indexOf(entry) : this.getPool().findClassEntry((String)entry.getConstant(), true);
            this.setOpcode(19);
        } else {
            throw new IllegalArgumentException(String.valueOf(value));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

