/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.jdbc.AbstractOutParameterResultSetHandler;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockRef;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockCallableStatement
extends MockPreparedStatement
implements CallableStatement {
    private AbstractOutParameterResultSetHandler resultSetHandler;
    private Map paramObjects = new HashMap();
    private Set outParameterSetIndexed = new HashSet();
    private Set outParameterSetNamed = new HashSet();
    private List batchParameters = new ArrayList();
    private boolean wasNull = false;

    public MockCallableStatement(Connection connection, String string) {
        super(connection, string);
    }

    public MockCallableStatement(Connection connection, String string, int n, int n2) {
        super(connection, string, n, n2);
    }

    public MockCallableStatement(Connection connection, String string, int n, int n2, int n3) {
        super(connection, string, n, n2, n3);
    }

    public void setCallableStatementResultSetHandler(AbstractOutParameterResultSetHandler abstractOutParameterResultSetHandler) {
        super.setPreparedStatementResultSetHandler(abstractOutParameterResultSetHandler);
        this.resultSetHandler = abstractOutParameterResultSetHandler;
    }

    public Map getNamedParameterMap() {
        return Collections.unmodifiableMap(this.paramObjects);
    }

    public Map getParameterMap() {
        HashMap hashMap = new HashMap(this.getIndexedParameterMap());
        hashMap.putAll(this.getNamedParameterMap());
        return Collections.unmodifiableMap(hashMap);
    }

    public Object getParameter(String string) {
        return this.paramObjects.get(string);
    }

    public Set getNamedRegisteredOutParameterSet() {
        return Collections.unmodifiableSet(this.outParameterSetNamed);
    }

    public boolean isOutParameterRegistered(int n) {
        return this.outParameterSetIndexed.contains(new Integer(n));
    }

    public Set getIndexedRegisteredOutParameterSet() {
        return Collections.unmodifiableSet(this.outParameterSetIndexed);
    }

    public boolean isOutParameterRegistered(String string) {
        return this.outParameterSetNamed.contains(string);
    }

    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.getParameterMap());
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.getParameterMap());
    }

    public void addBatch() throws SQLException {
        this.batchParameters.add(new HashMap(this.getParameterMap()));
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray = new int[this.batchParameters.size()];
        if (this.isQuery(this.getSQL())) {
            throw new BatchUpdateException("SQL " + this.getSQL() + " returned a ResultSet.", null);
        }
        for (int i = 0; i < nArray.length; ++i) {
            Map map = (Map)this.batchParameters.get(i);
            nArray[i] = this.executeUpdate(map);
        }
        return nArray;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.outParameterSetIndexed.add(new Integer(n));
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        this.outParameterSetNamed.add(string);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(string, n);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(string, n);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).byteValue();
            }
            return new Byte(object.toString());
        }
        return 0;
    }

    public double getDouble(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return new Double(object.toString());
        }
        return 0.0;
    }

    public float getFloat(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
            return new Float(object.toString()).floatValue();
        }
        return 0.0f;
    }

    public int getInt(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return new Integer(object.toString());
        }
        return 0;
    }

    public long getLong(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            return new Long(object.toString());
        }
        return 0L;
    }

    public short getShort(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
            return new Short(object.toString());
        }
        return 0;
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return new Boolean(object.toString());
        }
        return false;
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            return object.toString().getBytes();
        }
        return null;
    }

    public Object getObject(int n) throws SQLException {
        this.wasNull = false;
        Map map = this.getOutParameterMap();
        Object var3_3 = null;
        if (null != map) {
            var3_3 = map.get(new Integer(n));
        }
        if (null == var3_3) {
            this.wasNull = true;
        }
        return var3_3;
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            return object.toString();
        }
        return null;
    }

    public byte getByte(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).byteValue();
            }
            return new Byte(object.toString());
        }
        return 0;
    }

    public double getDouble(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            return new Double(object.toString());
        }
        return 0.0;
    }

    public float getFloat(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
            return new Float(object.toString()).floatValue();
        }
        return 0.0f;
    }

    public int getInt(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            return new Integer(object.toString());
        }
        return 0;
    }

    public long getLong(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
            return new Long(object.toString());
        }
        return 0L;
    }

    public short getShort(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
            return new Short(object.toString());
        }
        return 0;
    }

    public boolean getBoolean(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return new Boolean(object.toString());
        }
        return false;
    }

    public byte[] getBytes(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            return object.toString().getBytes();
        }
        return null;
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setObject(string, (Object)new Byte(by));
    }

    public void setDouble(String string, double d) throws SQLException {
        this.setObject(string, (Object)new Double(d));
    }

    public void setFloat(String string, float f) throws SQLException {
        this.setObject(string, (Object)new Float(f));
    }

    public void setInt(String string, int n) throws SQLException {
        this.setObject(string, (Object)new Integer(n));
    }

    public void setNull(String string, int n) throws SQLException {
        this.setObject(string, null);
    }

    public void setLong(String string, long l) throws SQLException {
        this.setObject(string, (Object)new Long(l));
    }

    public void setShort(String string, short s) throws SQLException {
        this.setObject(string, (Object)new Short(s));
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setObject(string, (Object)new Boolean(bl));
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setObject(string, (Object)byArray);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            return new BigDecimal(object.toString());
        }
        return null;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    public URL getURL(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof URL) {
                return (URL)object;
            }
            try {
                return new URL(object.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public Array getArray(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Array) {
                return (Array)object;
            }
            return new MockArray(object);
        }
        return null;
    }

    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Blob) {
                return (Blob)object;
            }
            return new MockBlob(this.getBytes(n));
        }
        return null;
    }

    public Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Clob) {
                return (Clob)object;
            }
            return new MockClob(this.getString(n));
        }
        return null;
    }

    public Date getDate(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Date) {
                return (Date)object;
            }
            return Date.valueOf(object.toString());
        }
        return null;
    }

    public Ref getRef(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Ref) {
                return (Ref)object;
            }
            return new MockRef(object);
        }
        return null;
    }

    public Time getTime(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Time) {
                return (Time)object;
            }
            return Time.valueOf(object.toString());
        }
        return null;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getObject(n);
        if (null != object) {
            if (object instanceof Timestamp) {
                return (Timestamp)object;
            }
            return Timestamp.valueOf(object.toString());
        }
        return null;
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(string, inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        byte[] byArray = StreamUtil.getStreamAsByteArray(inputStream, n);
        this.setObject(string, (Object)new ByteArrayInputStream(byArray));
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        String string2 = StreamUtil.getReaderAsString(reader, n);
        this.setObject(string, (Object)new StringReader(string2));
    }

    public Object getObject(String string) throws SQLException {
        this.wasNull = false;
        Map map = this.getOutParameterMap();
        Object var3_3 = null;
        if (null != map) {
            var3_3 = map.get(string);
        }
        if (null == var3_3) {
            this.wasNull = true;
        }
        return var3_3;
    }

    public void setObject(String string, Object object) throws SQLException {
        this.paramObjects.put(string, object);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(string, object);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(string, object);
    }

    public Object getObject(int n, Map map) throws SQLException {
        return this.getObject(n);
    }

    public String getString(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            return object.toString();
        }
        return null;
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(string, n);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setObject(string, (Object)string2);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            return new BigDecimal(object.toString());
        }
        return null;
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setObject(string, (Object)bigDecimal);
    }

    public URL getURL(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof URL) {
                return (URL)object;
            }
            try {
                return new URL(object.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.setObject(string, (Object)uRL);
    }

    public Array getArray(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Array) {
                return (Array)object;
            }
            return new MockArray(object);
        }
        return null;
    }

    public Blob getBlob(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Blob) {
                return (Blob)object;
            }
            return new MockBlob(this.getBytes(string));
        }
        return null;
    }

    public Clob getClob(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Clob) {
                return (Clob)object;
            }
            return new MockClob(this.getString(string));
        }
        return null;
    }

    public Date getDate(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Date) {
                return (Date)object;
            }
            return Date.valueOf(object.toString());
        }
        return null;
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setObject(string, (Object)date);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Ref getRef(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Ref) {
                return (Ref)object;
            }
            return new MockRef(object);
        }
        return null;
    }

    public Time getTime(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Time) {
                return (Time)object;
            }
            return Time.valueOf(object.toString());
        }
        return null;
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setObject(string, (Object)time);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        Object object = this.getObject(string);
        if (null != object) {
            if (object instanceof Timestamp) {
                return (Timestamp)object;
            }
            return Timestamp.valueOf(object.toString());
        }
        return null;
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setObject(string, (Object)timestamp);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(string);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(string);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(string);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(string);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(string, date);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(string, time);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(string, timestamp);
    }

    private Map getOutParameterMap() {
        Map map = this.resultSetHandler.getOutParameter(this.getSQL(), this.getParameterMap());
        if (null == map) {
            map = this.resultSetHandler.getOutParameter(this.getSQL());
        }
        if (null == map) {
            map = this.resultSetHandler.getGlobalOutParameter();
        }
        return map;
    }
}

