/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.ejb;

import com.mockrunner.ejb.Configuration;
import com.mockrunner.mock.ejb.MockUserTransaction;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mockejb.MockContainer;
import org.mockejb.jndi.MockContextFactory;

public class EJBMockObjectFactory {
    private static final Log log = LogFactory.getLog((Class)(class$com$mockrunner$mock$ejb$EJBMockObjectFactory == null ? (class$com$mockrunner$mock$ejb$EJBMockObjectFactory = EJBMockObjectFactory.class$("com.mockrunner.mock.ejb.EJBMockObjectFactory")) : class$com$mockrunner$mock$ejb$EJBMockObjectFactory));
    private Configuration configuration;
    private UserTransaction transaction;
    private MockContainer container;
    static /* synthetic */ Class class$com$mockrunner$mock$ejb$EJBMockObjectFactory;

    public EJBMockObjectFactory() {
        this(new Configuration());
    }

    public EJBMockObjectFactory(Configuration configuration) {
        this.configuration = configuration;
        this.initializeMockEJB();
    }

    private void initializeMockEJB() {
        try {
            MockContextFactory.setAsInitial();
            InitialContext initialContext = new InitialContext();
            this.container = new MockContainer((Context)initialContext);
            try {
                this.transaction = (UserTransaction)initialContext.lookup(this.configuration.getUserTransactionJNDIName());
            }
            catch (NameNotFoundException nameNotFoundException) {
                this.transaction = new MockUserTransaction();
                if (this.configuration.getBindMockUserTransactionToJNDI()) {
                    initialContext.rebind(this.configuration.getUserTransactionJNDIName(), (Object)this.transaction);
                    initialContext.rebind("javax.transaction.UserTransaction", (Object)this.transaction);
                    initialContext.rebind("java:comp/UserTransaction", (Object)this.transaction);
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            this.transaction = new MockUserTransaction();
        }
        if (this.transaction instanceof MockUserTransaction) {
            ((MockUserTransaction)this.transaction).reset();
        }
    }

    public MockUserTransaction getMockUserTransaction() {
        if (!(this.transaction instanceof MockUserTransaction)) {
            return null;
        }
        return (MockUserTransaction)this.transaction;
    }

    public UserTransaction getUserTransaction() {
        return this.transaction;
    }

    public MockContainer getMockContainer() {
        return this.container;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

